/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@KeepForSdk
public final class Objects {
    @KeepForSdk
    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    @KeepForSdk
    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    @KeepForSdk
    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object, null);
    }

    @KeepForSdk
    public static boolean checkBundlesEquality(Bundle bundle, Bundle bundle2) {
        if (bundle == null || bundle2 == null) {
            return bundle == bundle2;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        if (!set.containsAll(bundle2.keySet())) {
            return false;
        }
        for (String string2 : set) {
            if (Objects.equal(bundle.get(string2), bundle2.get(string2))) continue;
            return false;
        }
        return true;
    }

    private Objects() {
        throw new AssertionError((Object)"Uninstantiable");
    }

    @KeepForSdk
    public static final class ToStringHelper {
        private final List<String> zzff;
        private final Object zzfg;

        private ToStringHelper(Object object) {
            this.zzfg = Preconditions.checkNotNull(object);
            this.zzff = new ArrayList<String>();
        }

        @KeepForSdk
        public final ToStringHelper add(String string2, @Nullable Object object) {
            String string3 = Preconditions.checkNotNull(string2);
            String string4 = String.valueOf(object);
            this.zzff.add(new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append("=").append(string4).toString());
            return this;
        }

        @KeepForSdk
        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(100).append(this.zzfg.getClass().getSimpleName()).append('{');
            int n = this.zzff.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.zzff.get(i));
                if (i >= n - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.append('}').toString();
        }

        /* synthetic */ ToStringHelper(Object object, zzq zzq2) {
            this(object);
        }
    }
}

