/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

@KeepForSdk
public class LibraryVersion {
    private static final GmsLogger zzez = new GmsLogger("LibraryVersion", "");
    private static LibraryVersion zzfa = new LibraryVersion();
    private ConcurrentHashMap<String, String> zzfb = new ConcurrentHashMap();

    @KeepForSdk
    public static LibraryVersion getInstance() {
        return zzfa;
    }

    @VisibleForTesting
    protected LibraryVersion() {
    }

    @KeepForSdk
    public String getVersion(@NonNull String string2) {
        Preconditions.checkNotEmpty(string2, "Please provide a valid libraryName");
        if (this.zzfb.containsKey(string2)) {
            return this.zzfb.get(string2);
        }
        String string3 = null;
        Properties properties = new Properties();
        try {
            String string4 = String.format("/%s.properties", string2);
            InputStream inputStream = LibraryVersion.class.getResourceAsStream(string4);
            if (inputStream != null) {
                properties.load(inputStream);
                String string5 = string3 = properties.getProperty("version", null);
                zzez.v("LibraryVersion", new StringBuilder(12 + String.valueOf(string2).length() + String.valueOf(string5).length()).append(string2).append(" version is ").append(string5).toString());
            } else {
                String string6 = String.valueOf(string2);
                zzez.w("LibraryVersion", string6.length() != 0 ? "Failed to get app version for libraryName: ".concat(string6) : new String("Failed to get app version for libraryName: "));
            }
        }
        catch (IOException iOException) {
            String string7 = String.valueOf(string2);
            zzez.e("LibraryVersion", string7.length() != 0 ? "Failed to get app version for libraryName: ".concat(string7) : new String("Failed to get app version for libraryName: "), iOException);
        }
        if (string3 == null) {
            string3 = "UNKNOWN";
            zzez.d("LibraryVersion", ".properties file is dropped during release process. Failure to read app version is expected during Google internal testing where locally-built libraries are used");
        }
        this.zzfb.put(string2, string3);
        return string3;
    }
}

