/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.BinderThread;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    private static final Feature[] zzce = new Feature[0];
    @KeepForSdk
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    private int zzcf;
    private long zzcg;
    private long zzch;
    private int zzci;
    private long zzcj;
    @VisibleForTesting
    private zzh zzck;
    @KeepForSdk
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    private final Context mContext;
    private final Looper zzcl;
    private final GmsClientSupervisor zzcm;
    private final GoogleApiAvailabilityLight zzcn;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzco = new Object();
    @GuardedBy(value="mServiceBrokerLock")
    private IGmsServiceBroker zzcp;
    @VisibleForTesting
    protected ConnectionProgressReportCallbacks zzcq;
    @GuardedBy(value="mLock")
    private T zzcr;
    private final ArrayList<zzc<?>> zzcs = new ArrayList();
    @GuardedBy(value="mLock")
    private zzd zzct;
    @GuardedBy(value="mLock")
    private int zzcu = 1;
    private final BaseConnectionCallbacks zzcv;
    private final BaseOnConnectionFailedListener zzcw;
    private final int zzcx;
    private final String zzcy;
    private ConnectionResult zzcz = null;
    private boolean zzda = false;
    private volatile com.google.android.gms.common.internal.zzc zzdb = null;
    @VisibleForTesting
    protected AtomicInteger zzdc = new AtomicInteger(0);
    @KeepForSdk
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{"service_esmobile", "service_googleme"};

    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this(context, looper, GmsClientSupervisor.getInstance(context), GoogleApiAvailabilityLight.getInstance(), n, Preconditions.checkNotNull(baseConnectionCallbacks), Preconditions.checkNotNull(baseOnConnectionFailedListener), string2);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.zzcl = Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzcm = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcn = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzcx = n;
        this.zzcv = baseConnectionCallbacks;
        this.zzcw = baseOnConnectionFailedListener;
        this.zzcy = string2;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.mHandler = Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzcl = handler.getLooper();
        this.zzcm = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcn = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzcx = n;
        this.zzcv = baseConnectionCallbacks;
        this.zzcw = baseOnConnectionFailedListener;
        this.zzcy = null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @Nullable
    private final String zzj() {
        if (this.zzcy == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzcy;
    }

    @Nullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    private final void zza(com.google.android.gms.common.internal.zzc zzc2) {
        this.zzdb = zzc2;
    }

    @Nullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        com.google.android.gms.common.internal.zzc zzc2 = this.zzdb;
        if (zzc2 == null) {
            return null;
        }
        return zzc2.zzdm;
    }

    @Nullable
    @KeepForSdk
    protected abstract T createServiceInterface(IBinder var1);

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@NonNull T t) {
        this.zzch = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int n) {
        this.zzcf = n;
        this.zzcg = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzci = connectionResult.getErrorCode();
        this.zzcj = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        Preconditions.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzcu = n;
            this.zzcr = t;
            this.onSetConnectState(n, t);
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzct != null && baseGmsClient.zzck != null) {
                        String string3 = baseGmsClient.zzck.zzt();
                        string2 = baseGmsClient.zzck.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        baseGmsClient.zzcm.zza(baseGmsClient.zzck.zzt(), baseGmsClient.zzck.getPackageName(), baseGmsClient.zzck.zzq(), baseGmsClient.zzct, baseGmsClient.zzj(), baseGmsClient.zzck.getUseDynamicLookup());
                        baseGmsClient.zzdc.incrementAndGet();
                    }
                    baseGmsClient.zzct = baseGmsClient.new zzd(baseGmsClient.zzdc.get());
                    BaseGmsClient baseGmsClient2 = baseGmsClient;
                    zzh zzh2 = baseGmsClient.zzck = baseGmsClient2.zzcu == 3 && baseGmsClient2.getLocalStartServiceAction() != null ? new zzh(baseGmsClient2.getContext().getPackageName(), baseGmsClient2.getLocalStartServiceAction(), true, GmsClientSupervisor.getDefaultBindFlags(), false) : new zzh(baseGmsClient2.getStartServicePackage(), baseGmsClient2.getStartServiceAction(), false, GmsClientSupervisor.getDefaultBindFlags(), baseGmsClient2.getUseDynamicLookup());
                    if (baseGmsClient.zzck.getUseDynamicLookup() && baseGmsClient.getMinApkVersion() < 17895000) {
                        String string4 = String.valueOf(baseGmsClient.zzck.zzt());
                        throw new IllegalStateException(string4.length() != 0 ? "Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: ".concat(string4) : new String("Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: "));
                    }
                    boolean bl = baseGmsClient.zzck.getUseDynamicLookup();
                    String string5 = baseGmsClient.zzj();
                    zzd zzd2 = baseGmsClient.zzct;
                    int n2 = baseGmsClient.zzck.zzq();
                    String string6 = baseGmsClient.zzck.getPackageName();
                    String string7 = baseGmsClient.zzck.zzt();
                    if (baseGmsClient.zzcm.zza(new GmsClientSupervisor.zza(string7, string6, n2, bl), zzd2, string5)) break;
                    string2 = baseGmsClient.zzck.zzt();
                    String string8 = baseGmsClient.zzck.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string8).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string8).toString());
                    baseGmsClient.zza(16, null, baseGmsClient.zzdc.get());
                    break;
                }
                case 4: {
                    this.onConnectedLocked(t);
                    break;
                }
                case 1: {
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzct == null) break;
                    baseGmsClient.zzcm.zza(baseGmsClient.zzck.zzt(), baseGmsClient.zzck.getPackageName(), baseGmsClient.zzck.zzq(), baseGmsClient.zzct, baseGmsClient.zzj(), baseGmsClient.zzck.getUseDynamicLookup());
                    baseGmsClient.zzct = null;
                }
            }
            return;
        }
    }

    @KeepForSdk
    void onSetConnectState(int n, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcu != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzcn.isGooglePlayServicesAvailable(this.mContext, this.getMinApkVersion());
        if (n != 0) {
            this.zza(1, null);
            this.triggerNotAvailable(new LegacyClientCallbackAdapter(), n, null);
            return;
        }
        this.connect(new LegacyClientCallbackAdapter());
    }

    @KeepForSdk
    public void connect(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zzcq = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcu == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcu == 2 || this.zzcu == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzk() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcu == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void disconnect() {
        this.zzdc.incrementAndGet();
        Object object = this.zzcs;
        synchronized (object) {
            int n = this.zzcs.size();
            for (int i = 0; i < n; ++i) {
                this.zzcs.get(i).removeListener();
            }
            this.zzcs.clear();
        }
        object = this.zzco;
        synchronized (object) {
            this.zzcp = null;
        }
        this.zza(1, null);
    }

    @KeepForSdk
    public void triggerConnectionSuspended(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzdc.get(), n));
    }

    private final void zzb(int n) {
        int n2;
        if (this.zzk()) {
            n2 = 5;
            this.zzda = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzdc.get(), 16));
    }

    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks, int n, @Nullable PendingIntent pendingIntent) {
        this.zzcq = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzdc.get(), n, (Object)pendingIntent));
    }

    @KeepForSdk
    public final Context getContext() {
        return this.mContext;
    }

    @KeepForSdk
    public final Looper getLooper() {
        return this.zzcl;
    }

    @KeepForSdk
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    public Feature[] getApiFeatures() {
        return zzce;
    }

    @KeepForSdk
    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    @KeepForSdk
    protected void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzf(n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzg(n, null)));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @KeepForSdk
    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final T getService() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcu == 5) {
                throw new DeadObjectException();
            }
            this.checkConnected();
            Preconditions.checkState(this.zzcr != null, "Client is connected but service is null");
            return this.zzcr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(IAccountAccessor iAccountAccessor, Set<Scope> set) {
        Bundle bundle = this.getGetServiceRequestExtraArgs();
        Object object = this.mContext.getPackageName();
        Object object2 = new GetServiceRequest(this.zzcx);
        new GetServiceRequest(this.zzcx).zzak = object;
        object = bundle;
        v0.zzdw = object;
        GetServiceRequest getServiceRequest = object2;
        if (set != null) {
            object = set;
            getServiceRequest.zzdv = object.toArray(new Scope[object.size()]);
        }
        if (this.requiresSignIn()) {
            object2 = this;
            object = ((BaseGmsClient)object2).getAccount() != null ? ((BaseGmsClient)object2).getAccount() : new Account(DEFAULT_ACCOUNT, "com.google");
            object2 = getServiceRequest;
            getServiceRequest.zzdx = object;
            object = iAccountAccessor;
            if (object != null) {
                ((GetServiceRequest)object2).zzdu = object.asBinder();
            }
        } else if (this.requiresAccount()) {
            object = this.getAccount();
            getServiceRequest.zzdx = object;
        }
        object = zzce;
        getServiceRequest.zzdy = zzce;
        object = this.getApiFeatures();
        getServiceRequest.zzdz = object;
        try {
            Object object3 = this.zzco;
            synchronized (object3) {
                if (this.zzcp != null) {
                    GetServiceRequest getServiceRequest2 = getServiceRequest;
                    zze zze2 = new zze(this, this.zzdc.get());
                    IGmsServiceBroker iGmsServiceBroker = this.zzcp;
                    iGmsServiceBroker.getService(zze2, getServiceRequest2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.triggerConnectionSuspended(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.onPostInitHandler(8, null, null, this.zzdc.get());
            return;
        }
    }

    @KeepForSdk
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    @KeepForSdk
    protected Set<Scope> getScopes() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        IGmsServiceBroker iGmsServiceBroker;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzcu;
            t = this.zzcr;
        }
        object = this.zzco;
        synchronized (object) {
            iGmsServiceBroker = this.zzcp;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzch > 0L) {
            l = this.zzch;
            string3 = ((DateFormat)object).format(new Date(this.zzch));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzcg > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzcf) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzcf));
                }
            }
            l = this.zzcg;
            string3 = ((DateFormat)object).format(new Date(this.zzcg));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzcj > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzci));
            l = this.zzcj;
            string3 = ((DateFormat)object).format(new Date(this.zzcj));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = this.zzco;
        synchronized (object) {
            if (this.zzcp == null) {
                return null;
            }
            return this.zzcp.asBinder();
        }
    }

    private final boolean zzl() {
        if (this.zzda) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(this.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    public String getEndpointPackageName() {
        if (this.isConnected() && this.zzck != null) {
            return this.zzck.getPackageName();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @KeepForSdk
    protected boolean getUseDynamicLookup() {
        return false;
    }

    @VisibleForTesting
    public static final class zze
    extends IGmsCallbacks.zza {
        private BaseGmsClient zzdi;
        private final int zzdh;

        public zze(@NonNull BaseGmsClient baseGmsClient, int n) {
            this.zzdi = baseGmsClient;
            this.zzdh = n;
        }

        @Override
        @BinderThread
        public final void zza(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public final void onPostInitComplete(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            Preconditions.checkNotNull(this.zzdi, "onPostInitComplete can be called only once per call to getRemoteService");
            this.zzdi.onPostInitHandler(n, iBinder, bundle, this.zzdh);
            this.zzdi = null;
        }

        @Override
        @BinderThread
        public final void zza(int n, @NonNull IBinder iBinder, @NonNull com.google.android.gms.common.internal.zzc zzc2) {
            Preconditions.checkNotNull(this.zzdi, "onPostInitCompleteWithConnectionInfo can be called only once per call togetRemoteService");
            Preconditions.checkNotNull(zzc2);
            this.zzdi.zza(zzc2);
            this.onPostInitComplete(n, iBinder, zzc2.zzdl);
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        private final int statusCode;
        private final Bundle zzdd;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzdd = bundle;
        }

        protected abstract boolean zzm();

        @Override
        protected abstract void zza(ConnectionResult var1);

        @Override
        protected final void zzn() {
        }

        @Override
        protected final /* synthetic */ void zza(Object object) {
            Boolean bl = (Boolean)object;
            zza zza2 = this;
            if (bl == null) {
                zza2.BaseGmsClient.this.zza(1, null);
                return;
            }
            switch (zza2.statusCode) {
                case 0: {
                    if (zza2.zzm()) break;
                    zza2.BaseGmsClient.this.zza(1, null);
                    zza2.zza(new ConnectionResult(8, null));
                    return;
                }
                case 10: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    throw new IllegalStateException(String.format("A fatal developer error has occurred. Class name: %s. Start service action: %s. Service Descriptor: %s. ", zza2.getClass().getSimpleName(), zza2.BaseGmsClient.this.getStartServiceAction(), zza2.BaseGmsClient.this.getServiceDescriptor()));
                }
                default: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (zza2.zzdd != null) {
                        pendingIntent = (PendingIntent)zza2.zzdd.getParcelable(BaseGmsClient.KEY_PENDING_INTENT);
                    }
                    zza2.zza(new ConnectionResult(zza2.statusCode, pendingIntent));
                }
            }
        }
    }

    protected final class zzf
    extends zza {
        private final IBinder zzdj;

        @BinderThread
        public zzf(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzdj = iBinder;
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.zzcw != null) {
                BaseGmsClient.this.zzcw.onConnectionFailed(connectionResult);
            }
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzm() {
            String string2;
            try {
                string2 = this.zzdj.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!BaseGmsClient.this.getServiceDescriptor().equals(string2)) {
                String string3 = BaseGmsClient.this.getServiceDescriptor();
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = BaseGmsClient.this.createServiceInterface(this.zzdj);
            if (t != null && (BaseGmsClient.this.zza(2, 4, t) || BaseGmsClient.this.zza(3, 4, t))) {
                BaseGmsClient.this.zzcz = null;
                Bundle bundle = BaseGmsClient.this.getConnectionHint();
                if (BaseGmsClient.this.zzcv != null) {
                    BaseGmsClient.this.zzcv.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzg
    extends zza {
        @BinderThread
        public zzg(@Nullable int n, Bundle bundle) {
            super(n, null);
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.enableLocalFallback() && BaseGmsClient.this.zzl()) {
                BaseGmsClient.this.zzb(16);
                return;
            }
            BaseGmsClient.this.zzcq.onReportServiceBinding(connectionResult);
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzm() {
            BaseGmsClient.this.zzcq.onReportServiceBinding(ConnectionResult.RESULT_SUCCESS);
            return true;
        }
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        @KeepForSdk
        public LegacyClientCallbackAdapter() {
        }

        @Override
        public void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient.this.getRemoteService(null, BaseGmsClient.this.getScopes());
                return;
            }
            if (BaseGmsClient.this.zzcw != null) {
                BaseGmsClient.this.zzcw.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zzc<TListener> {
        private TListener zzdf;
        private boolean zzdg;

        public zzc(TListener TListener) {
            this.zzdf = TListener;
            this.zzdg = false;
        }

        protected abstract void zza(TListener var1);

        protected abstract void zzn();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzo() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.zzdf;
                if (this.zzdg) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zza(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzn();
                    throw runtimeException;
                }
            } else {
                this.zzn();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzdg = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unregister() {
            this.removeListener();
            ArrayList arrayList = BaseGmsClient.this.zzcs;
            synchronized (arrayList) {
                BaseGmsClient.this.zzcs.remove(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeListener() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.zzdf = null;
                return;
            }
        }
    }

    final class zzb
    extends zzi {
        public zzb(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (BaseGmsClient.this.zzdc.get() != message.arg1) {
                if (zzb.zzb(message)) {
                    zzb.zza(message);
                }
                return;
            }
            if ((message.what == 1 || message.what == 7 || message.what == 4 && !BaseGmsClient.this.enableLocalFallback() || message.what == 5) && !BaseGmsClient.this.isConnecting()) {
                zzb.zza(message);
                return;
            }
            if (message.what == 4) {
                BaseGmsClient.this.zzcz = new ConnectionResult(message.arg2);
                if (BaseGmsClient.this.zzl() && !BaseGmsClient.this.zzda) {
                    BaseGmsClient.this.zza(3, null);
                    return;
                }
                ConnectionResult connectionResult = BaseGmsClient.this.zzcz != null ? BaseGmsClient.this.zzcz : new ConnectionResult(8);
                BaseGmsClient.this.zzcq.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 5) {
                ConnectionResult connectionResult = BaseGmsClient.this.zzcz != null ? BaseGmsClient.this.zzcz : new ConnectionResult(8);
                BaseGmsClient.this.zzcq.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                BaseGmsClient.this.zzcq.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 6) {
                BaseGmsClient.this.zza(5, null);
                if (BaseGmsClient.this.zzcv != null) {
                    BaseGmsClient.this.zzcv.onConnectionSuspended(message.arg2);
                }
                BaseGmsClient.this.onConnectionSuspended(message.arg2);
                BaseGmsClient.this.zza(5, 1, null);
                return;
            }
            if (message.what == 2 && !BaseGmsClient.this.isConnected()) {
                zzb.zza(message);
                return;
            }
            if (zzb.zzb(message)) {
                ((zzc)message.obj).zzo();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private static void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzn();
            zzc2.unregister();
        }

        private static boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 7;
        }
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;

        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }

    @VisibleForTesting
    public final class zzd
    implements ServiceConnection {
        private final int zzdh;

        public zzd(int n) {
            this.zzdh = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                BaseGmsClient.this.zzb(16);
                return;
            }
            Object object = BaseGmsClient.this.zzco;
            synchronized (object) {
                IInterface iInterface;
                IBinder iBinder2 = iBinder;
                BaseGmsClient.this.zzcp = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.common.internal.IGmsServiceBroker")) != null && iInterface instanceof IGmsServiceBroker ? (IGmsServiceBroker)iInterface : new IGmsServiceBroker.Stub.zza(iBinder2));
            }
            BaseGmsClient.this.zza(0, null, this.zzdh);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(ComponentName componentName) {
            Object object = BaseGmsClient.this.zzco;
            synchronized (object) {
                BaseGmsClient.this.zzcp = null;
            }
            BaseGmsClient.this.mHandler.sendMessage(BaseGmsClient.this.mHandler.obtainMessage(6, this.zzdh, 1));
        }
    }
}

