/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzd;
import com.google.android.gms.common.zzg;
import com.google.android.gms.common.zzi;
import com.google.android.gms.common.zzl;
import javax.annotation.CheckReturnValue;

@CheckReturnValue
@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    private static GoogleSignatureVerifier zzat;
    private final Context mContext;
    private volatile String zzau;

    private GoogleSignatureVerifier(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static GoogleSignatureVerifier getInstance(Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (GoogleSignatureVerifier.class) {
            if (zzat == null) {
                zzc.zza(context);
                zzat = new GoogleSignatureVerifier(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzat;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public boolean isUidGoogleSigned(int n) {
        zzl zzl2;
        GoogleSignatureVerifier googleSignatureVerifier = this;
        String[] stringArray = Wrappers.packageManager(googleSignatureVerifier.mContext).getPackagesForUid(n);
        if (stringArray == null || stringArray.length == 0) {
            zzl2 = zzl.zzb("no pkgs");
        } else {
            zzl zzl3 = null;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String string2 = stringArray2[i];
                zzl3 = googleSignatureVerifier.zza(string2, n);
                if (zzl3.zzap) break;
            }
            zzl2 = zzl3;
        }
        zzl zzl4 = zzl2;
        zzl2.zzf();
        return zzl4.zzap;
    }

    @ShowFirstParty
    @KeepForSdk
    public boolean isPackageGoogleSigned(String string2) {
        zzl zzl2 = this.zzc(string2);
        zzl2.zzf();
        return zzl2.zzap;
    }

    public static boolean zza(PackageInfo packageInfo, boolean bl) {
        return packageInfo != null && packageInfo.signatures != null && (bl ? GoogleSignatureVerifier.zza(packageInfo, zzi.zzaj) : GoogleSignatureVerifier.zza(packageInfo, zzi.zzaj[0])) != null;
    }

    @KeepForSdk
    public boolean isGooglePublicSignedPackage(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zza(packageInfo, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zza(packageInfo, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    private final zzl zza(String string2, int n) {
        try {
            PackageInfo packageInfo;
            PackageInfo packageInfo2 = packageInfo = Wrappers.packageManager(this.mContext).zza(string2, 64, n);
            boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext);
            PackageInfo packageInfo3 = packageInfo2;
            if (packageInfo3 == null) {
                return zzl.zzb("null pkg");
            }
            if (packageInfo3.signatures == null || packageInfo3.signatures.length != 1) {
                return zzl.zzb("single cert required");
            }
            zzg zzg2 = new zzg(packageInfo3.signatures[0].toByteArray());
            String string3 = packageInfo3.packageName;
            zzl zzl2 = zzc.zza(string3, zzg2, bl, false);
            if (zzl2.zzap && packageInfo3.applicationInfo != null && (packageInfo3.applicationInfo.flags & 2) != 0 && zzc.zza((String)string3, (zzd)zzg2, (boolean)false, (boolean)true).zzap) {
                return zzl.zzb("debuggable release cert app rejected");
            }
            return zzl2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string4 = String.valueOf(string2);
            return zzl.zzb(string4.length() != 0 ? "no pkg ".concat(string4) : new String("no pkg "));
        }
    }

    private final zzl zzc(String string2) {
        zzl zzl2;
        zzl zzl3;
        PackageInfo packageInfo;
        PackageInfo packageInfo2;
        if (string2 == null) {
            return zzl.zzb("null pkg");
        }
        if (string2.equals(this.zzau)) {
            return zzl.zze();
        }
        try {
            packageInfo2 = Wrappers.packageManager(this.mContext).getPackageInfo(string2, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            return zzl.zzb(string3.length() != 0 ? "no pkg ".concat(string3) : new String("no pkg "));
        }
        PackageInfo packageInfo3 = packageInfo = packageInfo2;
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext);
        PackageInfo packageInfo4 = packageInfo3;
        if (packageInfo4 == null) {
            zzl3 = zzl.zzb("null pkg");
        } else if (packageInfo4.signatures == null || packageInfo4.signatures.length != 1) {
            zzl3 = zzl.zzb("single cert required");
        } else {
            zzg zzg2 = new zzg(packageInfo4.signatures[0].toByteArray());
            String string4 = packageInfo4.packageName;
            zzl zzl4 = zzc.zza(string4, zzg2, bl, false);
            zzl3 = zzl2 = zzl4.zzap && packageInfo4.applicationInfo != null && (packageInfo4.applicationInfo.flags & 2) != 0 && zzc.zza((String)string4, (zzd)zzg2, (boolean)false, (boolean)true).zzap ? zzl.zzb("debuggable release cert app rejected") : zzl4;
        }
        if (zzl3.zzap) {
            this.zzau = string2;
        }
        return zzl2;
    }

    private static zzd zza(PackageInfo packageInfo, zzd ... zzdArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzg zzg2 = new zzg(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zzdArray.length; ++i) {
            if (!zzdArray[i].equals(zzg2)) continue;
            return zzdArray[i];
        }
        return null;
    }
}

