/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzf;

@KeepForSdk
public abstract class GmsClientSupervisor {
    private static int zzef = 129;
    private static final Object zzeg = new Object();
    private static GmsClientSupervisor zzeh;

    @KeepForSdk
    public static int getDefaultBindFlags() {
        return zzef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static GmsClientSupervisor getInstance(Context context) {
        Object object = zzeg;
        synchronized (object) {
            if (zzeh == null) {
                zzeh = new zzf(context.getApplicationContext());
            }
        }
        return zzeh;
    }

    @KeepForSdk
    public boolean bindService(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string3);
    }

    @KeepForSdk
    public boolean bindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string2);
    }

    @KeepForSdk
    public void unbindService(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string3);
    }

    public final void zza(String string2, String string3, int n, ServiceConnection serviceConnection, String string4, boolean bl) {
        this.zzb(new zza(string2, string3, n, bl), serviceConnection, string4);
    }

    @KeepForSdk
    public void unbindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string2);
    }

    protected abstract boolean zza(zza var1, ServiceConnection var2, String var3);

    protected abstract void zzb(zza var1, ServiceConnection var2, String var3);

    protected static final class zza {
        @Nullable
        private final String zzeb;
        @Nullable
        private final String packageName;
        @Nullable
        private final ComponentName componentName;
        private final int zzec;
        private final boolean zzed;
        private static final Uri zzee = new Uri.Builder().scheme("content").authority("com.google.android.gms.chimera").build();

        public zza(String string2, int n) {
            this(string2, "com.google.android.gms", n);
        }

        private zza(String string2, String string3, int n) {
            this(string2, string3, n, false);
        }

        public zza(String string2, String string3, int n, boolean bl) {
            this.zzeb = Preconditions.checkNotEmpty(string2);
            this.packageName = Preconditions.checkNotEmpty(string3);
            this.componentName = null;
            this.zzec = n;
            this.zzed = bl;
        }

        public zza(ComponentName componentName, int n) {
            this.zzeb = null;
            this.packageName = null;
            this.componentName = Preconditions.checkNotNull(componentName);
            this.zzec = n;
            this.zzed = false;
        }

        public final String toString() {
            if (this.zzeb == null) {
                Preconditions.checkNotNull(this.componentName);
                return this.componentName.flattenToString();
            }
            return this.zzeb;
        }

        @Nullable
        public final String getPackage() {
            return this.packageName;
        }

        @Nullable
        public final ComponentName getComponentName() {
            return this.componentName;
        }

        public final int zzq() {
            return this.zzec;
        }

        public final Intent zzb(Context context) {
            Intent intent = null;
            if (this.zzeb != null) {
                if (this.zzed) {
                    intent = this.zzc(context);
                }
                if (intent == null) {
                    intent = new Intent(this.zzeb).setPackage(this.packageName);
                }
            } else {
                intent = new Intent().setComponent(this.componentName);
            }
            return intent;
        }

        @Nullable
        private final Intent zzc(Context context) {
            Intent intent;
            Bundle bundle = new Bundle();
            bundle.putString("serviceActionBundleKey", this.zzeb);
            Bundle bundle2 = null;
            try {
                bundle2 = context.getContentResolver().call(zzee, "serviceIntentCall", null, bundle);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = String.valueOf(illegalArgumentException);
                Log.w((String)"ConnectionStatusConfig", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("Dynamic intent resolution failed: ").append(string2).toString());
            }
            if ((intent = bundle2 == null ? null : (Intent)bundle2.getParcelable("serviceResponseIntentKey")) == null) {
                String string3 = String.valueOf(this.zzeb);
                Log.w((String)"ConnectionStatusConfig", (String)(string3.length() != 0 ? "Dynamic lookup for intent failed for action: ".concat(string3) : new String("Dynamic lookup for intent failed for action: ")));
            }
            return intent;
        }

        public final int hashCode() {
            return Objects.hashCode(this.zzeb, this.packageName, this.componentName, this.zzec, this.zzed);
        }

        public final boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return Objects.equal(this.zzeb, zza2.zzeb) && Objects.equal(this.packageName, zza2.packageName) && Objects.equal(this.componentName, zza2.componentName) && this.zzec == zza2.zzec && this.zzed == zza2.zzed;
        }
    }
}

