/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.wrappers;

import android.content.Context;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;

@KeepForSdk
public class InstantApps {
    private static Context zzim;
    private static Boolean zzin;

    @KeepForSdk
    public static synchronized boolean isInstantApp(Context context) {
        Context context2 = context.getApplicationContext();
        if (zzim != null && zzin != null && zzim == context2) {
            return zzin;
        }
        zzin = null;
        if (PlatformVersion.isAtLeastO()) {
            zzin = context2.getPackageManager().isInstantApp();
        } else {
            try {
                context.getClassLoader().loadClass("com.google.android.instantapps.supervisor.InstantAppsRuntime");
                zzin = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzin = false;
            }
        }
        zzim = context2;
        return zzin;
    }
}

