/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.wrappers.Wrappers;

@KeepForSdk
public class ClientLibraryUtils {
    private ClientLibraryUtils() {
    }

    @KeepForSdk
    public static int getClientVersion(Context context, String string2) {
        PackageInfo packageInfo = ClientLibraryUtils.zzb(context, string2);
        if (packageInfo == null || packageInfo.applicationInfo == null) {
            return -1;
        }
        Bundle bundle = packageInfo.applicationInfo.metaData;
        if (bundle == null) {
            return -1;
        }
        return bundle.getInt("com.google.android.gms.version", -1);
    }

    @Nullable
    private static PackageInfo zzb(Context context, String string2) {
        PackageInfo packageInfo;
        try {
            packageInfo = Wrappers.packageManager(context).getPackageInfo(string2, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return packageInfo;
    }

    public static boolean zzc(Context context, String string2) {
        if ("com.google.android.gms".equals(string2)) {
        }
        try {
            return (Wrappers.packageManager((Context)context).getApplicationInfo((String)string2, (int)0).flags & 0x200000) != 0;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    public static boolean isPackageSide() {
        return false;
    }
}

