/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public final class GmsLogger {
    private static final int zzev = 15;
    private static final String zzew = null;
    private final String zzex;
    private final String zzey;

    public GmsLogger(String string2, String string3) {
        Preconditions.checkNotNull(string2, "log tag cannot be null");
        Preconditions.checkArgument(string2.length() <= 23, "tag \"%s\" is longer than the %d character maximum", string2, 23);
        this.zzex = string2;
        if (string3 == null || string3.length() <= 0) {
            this.zzey = null;
            return;
        }
        this.zzey = string3;
    }

    public GmsLogger(String string2) {
        this(string2, null);
    }

    @KeepForSdk
    public final boolean canLog(int n) {
        return Log.isLoggable((String)this.zzex, (int)n);
    }

    @KeepForSdk
    public final boolean canLogPii() {
        return false;
    }

    @KeepForSdk
    public final void d(String string2, String string3) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zzh(string3));
        }
    }

    @KeepForSdk
    public final void d(String string2, String string3, Throwable throwable) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zzh(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void v(String string2, String string3) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zzh(string3));
        }
    }

    @KeepForSdk
    public final void v(String string2, String string3, Throwable throwable) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zzh(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void i(String string2, String string3) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zzh(string3));
        }
    }

    @KeepForSdk
    public final void i(String string2, String string3, Throwable throwable) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zzh(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void w(String string2, String string3) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zzh(string3));
        }
    }

    @KeepForSdk
    public final void w(String string2, String string3, Throwable throwable) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zzh(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void wfmt(String string2, String string3, Object ... objectArray) {
        if (this.canLog(5)) {
            Log.w((String)this.zzex, (String)this.zza(string3, objectArray));
        }
    }

    @KeepForSdk
    public final void e(String string2, String string3) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zzh(string3));
        }
    }

    @KeepForSdk
    public final void e(String string2, String string3, Throwable throwable) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zzh(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void efmt(String string2, String string3, Object ... objectArray) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zza(string3, objectArray));
        }
    }

    @KeepForSdk
    public final void wtf(String string2, String string3, Throwable throwable) {
        if (this.canLog(7)) {
            Log.e((String)string2, (String)this.zzh(string3), (Throwable)throwable);
            Log.wtf((String)string2, (String)this.zzh(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void pii(String string2, String string3) {
        if (this.canLogPii()) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf(" PII_LOG");
            Log.i((String)(string5.length() != 0 ? string4.concat(string5) : new String(string4)), (String)this.zzh(string3));
        }
    }

    @KeepForSdk
    public final void pii(String string2, String string3, Throwable throwable) {
        if (this.canLogPii()) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf(" PII_LOG");
            Log.i((String)(string5.length() != 0 ? string4.concat(string5) : new String(string4)), (String)this.zzh(string3), (Throwable)throwable);
        }
    }

    private final String zzh(String string2) {
        if (this.zzey == null) {
            return string2;
        }
        return this.zzey.concat(string2);
    }

    private final String zza(String string2, Object ... objectArray) {
        String string3 = String.format(string2, objectArray);
        if (this.zzey == null) {
            return string3;
        }
        return this.zzey.concat(string3);
    }
}

