/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzc;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzd
extends Fragment
implements LifecycleFragment {
    private static WeakHashMap<FragmentActivity, WeakReference<zzd>> zzbq = new WeakHashMap();
    private Map<String, LifecycleCallback> zzbr = new ArrayMap();
    private int zzbs = 0;
    private Bundle zzbt;

    public static zzd zza(FragmentActivity fragmentActivity) {
        zzd zzd2;
        WeakReference<zzd> weakReference = zzbq.get(fragmentActivity);
        if (weakReference != null && (zzd2 = (zzd)weakReference.get()) != null) {
            return zzd2;
        }
        try {
            zzd2 = (zzd)fragmentActivity.getSupportFragmentManager().findFragmentByTag("SupportLifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag SupportLifecycleFragmentImpl is not a SupportLifecycleFragmentImpl", classCastException);
        }
        if (zzd2 == null || zzd2.isRemoving()) {
            zzd2 = new zzd();
            fragmentActivity.getSupportFragmentManager().beginTransaction().add((Fragment)zzd2, "SupportLifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzbq.put(fragmentActivity, new WeakReference<zzd>(zzd2));
        return zzd2;
    }

    @Override
    public final <T extends LifecycleCallback> T getCallbackOrNull(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzbr.get(string2)));
    }

    @Override
    public final void addCallback(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzbr.containsKey(string2)) {
            this.zzbr.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzd zzd2 = this;
            if (zzd2.zzbs > 0) {
                new zzi(Looper.getMainLooper()).post(new zzc(zzd2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final boolean isCreated() {
        return this.zzbs > 0;
    }

    @Override
    public final boolean isStarted() {
        return this.zzbs >= 2;
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbs = 1;
        this.zzbt = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzbr.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzbs = 2;
        Iterator<LifecycleCallback> iterator = this.zzbr.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzbs = 3;
        Iterator<LifecycleCallback> iterator = this.zzbr.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzbr.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzbr.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzbs = 4;
        Iterator<LifecycleCallback> iterator = this.zzbr.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzbs = 5;
        Iterator<LifecycleCallback> iterator = this.zzbr.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzbr.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    public final /* synthetic */ Activity getLifecycleActivity() {
        return this.getActivity();
    }

    static /* synthetic */ int zza(zzd zzd2) {
        return zzd2.zzbs;
    }

    static /* synthetic */ Bundle zzb(zzd zzd2) {
        return zzd2.zzbt;
    }
}

