/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zza;

@SafeParcelable.Class(creator="ConnectionResultCreator")
public final class ConnectionResult
extends AbstractSafeParcelable {
    @KeepForSdk
    public static final int UNKNOWN = -1;
    public static final int SUCCESS = 0;
    public static final int SERVICE_MISSING = 1;
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    public static final int SERVICE_DISABLED = 3;
    public static final int SIGN_IN_REQUIRED = 4;
    public static final int INVALID_ACCOUNT = 5;
    public static final int RESOLUTION_REQUIRED = 6;
    public static final int NETWORK_ERROR = 7;
    public static final int INTERNAL_ERROR = 8;
    public static final int SERVICE_INVALID = 9;
    public static final int DEVELOPER_ERROR = 10;
    public static final int LICENSE_CHECK_FAILED = 11;
    public static final int CANCELED = 13;
    public static final int TIMEOUT = 14;
    public static final int INTERRUPTED = 15;
    public static final int API_UNAVAILABLE = 16;
    public static final int SIGN_IN_FAILED = 17;
    public static final int SERVICE_UPDATING = 18;
    public static final int SERVICE_MISSING_PERMISSION = 19;
    public static final int RESTRICTED_PROFILE = 20;
    @Deprecated
    public static final int DRIVE_EXTERNAL_STORAGE_REQUIRED = 1500;
    @ShowFirstParty
    @KeepForSdk
    public static final ConnectionResult RESULT_SUCCESS = new ConnectionResult(0);
    public static final Parcelable.Creator<ConnectionResult> CREATOR = new zza();
    @SafeParcelable.VersionField(id=1)
    private final int zzq;
    @SafeParcelable.Field(id=2, getter="getErrorCode")
    private final int zzr;
    @SafeParcelable.Field(id=3, getter="getResolution")
    private final PendingIntent zzs;
    @SafeParcelable.Field(id=4, getter="getErrorMessage")
    private final String zzt;

    @SafeParcelable.Constructor
    ConnectionResult(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) PendingIntent pendingIntent, @SafeParcelable.Param(id=4) String string) {
        this.zzq = n;
        this.zzr = n2;
        this.zzs = pendingIntent;
        this.zzt = string;
    }

    public ConnectionResult(int n) {
        this(n, null, null);
    }

    public ConnectionResult(int n, @Nullable PendingIntent pendingIntent) {
        this(n, pendingIntent, null);
    }

    public ConnectionResult(int n, @Nullable PendingIntent pendingIntent, String string) {
        this(1, n, pendingIntent, string);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzs.getIntentSender(), n, null, 0, 0, 0);
    }

    public final boolean hasResolution() {
        return this.zzr != 0 && this.zzs != null;
    }

    public final boolean isSuccess() {
        return this.zzr == 0;
    }

    public final int getErrorCode() {
        return this.zzr;
    }

    @Nullable
    public final PendingIntent getResolution() {
        return this.zzs;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.zzt;
    }

    static String zza(int n) {
        switch (n) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 13: {
                return "CANCELED";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 15: {
                return "INTERRUPTED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
            case 17: {
                return "SIGN_IN_FAILED";
            }
            case 18: {
                return "SERVICE_UPDATING";
            }
            case 19: {
                return "SERVICE_MISSING_PERMISSION";
            }
            case 20: {
                return "RESTRICTED_PROFILE";
            }
            case 21: {
                return "API_VERSION_UPDATE_REQUIRED";
            }
            case 1500: {
                return "DRIVE_EXTERNAL_STORAGE_REQUIRED";
            }
            case 99: {
                return "UNFINISHED";
            }
            case -1: {
                return "UNKNOWN";
            }
        }
        return new StringBuilder(31).append("UNKNOWN_ERROR_CODE(").append(n).append(")").toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConnectionResult)) {
            return false;
        }
        ConnectionResult connectionResult = (ConnectionResult)object;
        return this.zzr == connectionResult.zzr && Objects.equal(this.zzs, connectionResult.zzs) && Objects.equal(this.zzt, connectionResult.zzt);
    }

    public final int hashCode() {
        return Objects.hashCode(this.zzr, this.zzs, this.zzt);
    }

    public final String toString() {
        return Objects.toStringHelper(this).add("statusCode", ConnectionResult.zza(this.zzr)).add("resolution", this.zzs).add("message", this.zzt).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ConnectionResult connectionResult = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, connectionResult.zzq);
        SafeParcelWriter.writeInt(parcel2, 2, connectionResult.getErrorCode());
        SafeParcelWriter.writeParcelable(parcel2, 3, (Parcelable)connectionResult.getResolution(), n, false);
        SafeParcelWriter.writeString(parcel2, 4, connectionResult.getErrorMessage(), false);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }
}

