/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.stats.LoggingConstants;
import com.google.android.gms.common.stats.StatsUtils;
import com.google.android.gms.common.stats.WakeLockEvent;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.zza;
import java.util.Arrays;
import java.util.List;

@KeepForSdk
public class WakeLockTracker {
    private static WakeLockTracker zzgr = new WakeLockTracker();
    private static Boolean zzgs;
    @VisibleForTesting
    private static boolean zzgt;

    @KeepForSdk
    public static WakeLockTracker getInstance() {
        return zzgr;
    }

    @KeepForSdk
    public void registerAcquireEvent(Context context, Intent intent, String string2, String string3, String string4, int n, String string5) {
        List<String> list = Arrays.asList(string5);
        String string6 = string4;
        String string7 = string3;
        String string8 = string2;
        Intent intent2 = intent;
        Context context2 = context;
        this.registerEvent(context2, intent2.getStringExtra("WAKE_LOCK_KEY"), 7, string8, string7, string6, n, list);
    }

    @KeepForSdk
    public void registerReleaseEvent(Context context, Intent intent) {
        this.registerEvent(context, intent.getStringExtra("WAKE_LOCK_KEY"), 8, null, null, null, 0, null);
    }

    @KeepForSdk
    public void registerEvent(Context context, String string2, int n, String string3, String string4, String string5, int n2, List<String> list) {
        this.registerEvent(context, string2, n, string3, string4, string5, n2, list, 0L);
    }

    @KeepForSdk
    public void registerEvent(Context context, String string2, int n, String string3, String string4, String string5, int n2, List<String> list, long l) {
        if (!WakeLockTracker.zzw()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            String string6 = String.valueOf(string2);
            Log.e((String)"WakeLockTracker", (String)(string6.length() != 0 ? "missing wakeLock key. ".concat(string6) : new String("missing wakeLock key. ")));
            return;
        }
        if (7 == n || 8 == n || 10 == n || 11 == n) {
            long l2 = System.currentTimeMillis();
            WakeLockEvent wakeLockEvent = new WakeLockEvent(l2, n, string3, n2, StatsUtils.zza(list), string2, SystemClock.elapsedRealtime(), zza.zzh(context), string4, StatsUtils.zzi(context.getPackageName()), zza.zzi(context), l, string5, false);
            WakeLockTracker.zza(context, wakeLockEvent);
        }
    }

    @KeepForSdk
    public void registerDeadlineEvent(Context context, String string2, String string3, String string4, int n, List<String> list, boolean bl, long l) {
        if (!WakeLockTracker.zzw()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        WakeLockEvent wakeLockEvent = new WakeLockEvent(l2, 16, string2, n, StatsUtils.zza(list), null, l, zza.zzh(context), string3, StatsUtils.zzi(context.getPackageName()), zza.zzi(context), 0L, string4, bl);
        WakeLockTracker.zza(context, wakeLockEvent);
    }

    private static void zza(Context context, WakeLockEvent wakeLockEvent) {
        try {
            context.startService(new Intent().setComponent(LoggingConstants.zzfo).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)wakeLockEvent));
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WakeLockTracker", (Throwable)exception);
            return;
        }
    }

    private static boolean zzw() {
        if (zzgs == null) {
            zzgs = false;
        }
        return zzgs;
    }

    static {
        zzgt = false;
    }
}

