/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zze;

@KeepForSdk
public abstract class GmsClientSupervisor {
    private static final Object zzec = new Object();
    private static GmsClientSupervisor zzed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static GmsClientSupervisor getInstance(Context context) {
        Object object = zzec;
        synchronized (object) {
            if (zzed == null) {
                zzed = new zze(context.getApplicationContext());
            }
        }
        return zzed;
    }

    @KeepForSdk
    public boolean bindService(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2, 129), serviceConnection, string3);
    }

    @KeepForSdk
    public boolean bindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName, 129), serviceConnection, string2);
    }

    @KeepForSdk
    public void unbindService(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2, 129), serviceConnection, string3);
    }

    public final void zza(String string2, String string3, int n, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3, n), serviceConnection, string4);
    }

    @KeepForSdk
    public void unbindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName, 129), serviceConnection, string2);
    }

    protected abstract boolean zza(zza var1, ServiceConnection var2, String var3);

    protected abstract void zzb(zza var1, ServiceConnection var2, String var3);

    protected static final class zza {
        private final String zzej;
        private final String packageName;
        private final ComponentName componentName;
        private final int zzek;
        private final boolean zzel;
        private static final Uri zzem = new Uri.Builder().scheme("content").authority("com.google.android.gms.chimera").build();

        public zza(String string2, int n) {
            this(string2, "com.google.android.gms", 129);
        }

        public zza(String string2, String string3, int n) {
            this(string2, string3, n, false);
        }

        public zza(String string2, String string3, int n, boolean bl) {
            this.zzej = Preconditions.checkNotEmpty(string2);
            this.packageName = Preconditions.checkNotEmpty(string3);
            this.componentName = null;
            this.zzek = n;
            this.zzel = bl;
        }

        public zza(ComponentName componentName, int n) {
            this.zzej = null;
            this.packageName = null;
            this.componentName = Preconditions.checkNotNull(componentName);
            this.zzek = 129;
            this.zzel = false;
        }

        public final String toString() {
            if (this.zzej == null) {
                return this.componentName.flattenToString();
            }
            return this.zzej;
        }

        public final String getPackage() {
            return this.packageName;
        }

        public final ComponentName getComponentName() {
            return this.componentName;
        }

        public final int zzq() {
            return this.zzek;
        }

        public final Intent zzb(Context context) {
            Intent intent = null;
            if (this.zzej != null) {
                if (this.zzel) {
                    Context context2 = context;
                    zza zza2 = this;
                    Bundle bundle = new Bundle();
                    bundle.putString("serviceActionBundleKey", zza2.zzej);
                    Bundle bundle2 = context2.getContentResolver().call(zzem, "serviceIntentCall", null, bundle);
                    Intent intent2 = bundle2 == null ? null : (Intent)bundle2.getParcelable("serviceResponseIntentKey");
                    if (intent2 == null) {
                        String string2 = String.valueOf(zza2.zzej);
                        Log.w((String)"ConnectionStatusConfig", (String)(string2.length() != 0 ? "Dynamic lookup for intent failed for action: ".concat(string2) : new String("Dynamic lookup for intent failed for action: ")));
                    }
                    intent = intent2;
                }
                if (intent == null) {
                    intent = new Intent(this.zzej).setPackage(this.packageName);
                }
            } else {
                intent = new Intent().setComponent(this.componentName);
            }
            return intent;
        }

        public final int hashCode() {
            return Objects.hashCode(this.zzej, this.packageName, this.componentName, this.zzek, this.zzel);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return Objects.equal(this.zzej, zza2.zzej) && Objects.equal(this.packageName, zza2.packageName) && Objects.equal(this.componentName, zza2.componentName) && this.zzek == zza2.zzek && this.zzel == zza2.zzel;
        }
    }
}

