/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.WorkSource;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.wrappers.Wrappers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@KeepForSdk
public class WorkSourceUtil {
    private static final int zzhi = Process.myUid();
    private static final Method zzhj = WorkSourceUtil.zzx();
    private static final Method zzhk = WorkSourceUtil.zzy();
    private static final Method zzhl = WorkSourceUtil.zzz();
    private static final Method zzhm = WorkSourceUtil.zzaa();
    private static final Method zzhn = WorkSourceUtil.zzab();
    private static final Method zzho = WorkSourceUtil.zzac();
    private static final Method zzhp = WorkSourceUtil.zzad();

    private WorkSourceUtil() {
    }

    private static WorkSource zza(int n, String string2) {
        WorkSource workSource = new WorkSource();
        WorkSourceUtil.zza(workSource, n, string2);
        return workSource;
    }

    @Nullable
    @KeepForSdk
    public static WorkSource fromPackage(Context context, @Nullable String string2) {
        ApplicationInfo applicationInfo;
        if (context == null || context.getPackageManager() == null || string2 == null) {
            return null;
        }
        try {
            applicationInfo = Wrappers.packageManager(context).getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string3.length() != 0 ? "Could not find package: ".concat(string3) : new String("Could not find package: ")));
            return null;
        }
        if (applicationInfo == null) {
            String string4 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string4.length() != 0 ? "Could not get applicationInfo from package: ".concat(string4) : new String("Could not get applicationInfo from package: ")));
            return null;
        }
        return WorkSourceUtil.zza(applicationInfo.uid, string2);
    }

    private static void zza(WorkSource workSource, int n, @Nullable String string2) {
        if (zzhk != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                zzhk.invoke((Object)workSource, n, string2);
                return;
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
                return;
            }
        }
        if (zzhj != null) {
            try {
                zzhj.invoke((Object)workSource, n);
                return;
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    @KeepForSdk
    public static WorkSource fromPackageAndModuleExperimentalPi(Context context, String string2, String string3) {
        if (context == null || context.getPackageManager() == null || string3 == null || string2 == null) {
            Log.w((String)"WorkSourceUtil", (String)"Unexpected null arguments");
            return null;
        }
        int n = WorkSourceUtil.zzd(context, string2);
        if (n < 0) {
            return null;
        }
        WorkSource workSource = new WorkSource();
        String string4 = string3;
        String string5 = string2;
        int n2 = n;
        WorkSource workSource2 = workSource;
        if (zzho == null || zzhp == null) {
            WorkSourceUtil.zza(workSource2, n2, string5);
        } else {
            try {
                Object object = zzho.invoke((Object)workSource2, new Object[0]);
                if (n2 != zzhi) {
                    zzhp.invoke(object, n2, string5);
                }
                zzhp.invoke(object, zzhi, string4);
            }
            catch (Exception exception) {
                Log.w((String)"WorkSourceUtil", (String)"Unable to assign chained blame through WorkSource", (Throwable)exception);
            }
        }
        return workSource;
    }

    private static int zza(WorkSource workSource) {
        if (zzhl != null) {
            try {
                return (Integer)zzhl.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    @Nullable
    private static String zza(WorkSource workSource, int n) {
        if (zzhn != null) {
            try {
                return (String)zzhn.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    @KeepForSdk
    public static List<String> getNames(@Nullable WorkSource workSource) {
        int n = workSource == null ? 0 : WorkSourceUtil.zza(workSource);
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string2 = WorkSourceUtil.zza(workSource, i);
            if (Strings.isEmptyOrWhitespace(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @KeepForSdk
    public static boolean hasWorkSourcePermission(Context context) {
        if (context == null) {
            return false;
        }
        if (context.getPackageManager() == null) {
            return false;
        }
        return Wrappers.packageManager(context).checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName()) == 0;
    }

    private static int zzd(Context context, String string2) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = Wrappers.packageManager(context).getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string3.length() != 0 ? "Could not find package: ".concat(string3) : new String("Could not find package: ")));
            return -1;
        }
        if (applicationInfo == null) {
            String string4 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string4.length() != 0 ? "Could not get applicationInfo from package: ".concat(string4) : new String("Could not get applicationInfo from package: ")));
            return -1;
        }
        return applicationInfo.uid;
    }

    private static Method zzx() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzy() {
        Method method = null;
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {}
        }
        return method;
    }

    private static Method zzz() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzaa() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzab() {
        Method method = null;
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {}
        }
        return method;
    }

    private static final Method zzac() {
        Method method = null;
        if (PlatformVersion.isAtLeastP()) {
            try {
                method = WorkSource.class.getMethod("createWorkChain", new Class[0]);
            }
            catch (Exception exception) {
                Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain API createWorkChain", (Throwable)exception);
            }
        }
        return method;
    }

    @SuppressLint(value={"PrivateApi"})
    private static final Method zzad() {
        Method method = null;
        if (PlatformVersion.isAtLeastP()) {
            try {
                method = Class.forName("android.os.WorkSource$WorkChain").getMethod("addNode", Integer.TYPE, String.class);
            }
            catch (Exception exception) {
                Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain class", (Throwable)exception);
            }
        }
        return method;
    }
}

