/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.zze;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzf
implements ServiceConnection {
    private final Set<ServiceConnection> zzdz;
    private int mState;
    private boolean zzea;
    private IBinder zzcz;
    private final GmsClientSupervisor.zza zzeb;
    private ComponentName mComponentName;
    private final /* synthetic */ zze zzec;

    public zzf(zze zze2, GmsClientSupervisor.zza zza2) {
        this.zzec = zze2;
        this.zzeb = zza2;
        this.zzdz = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zze.zza(this.zzec);
        synchronized (hashMap) {
            zze.zzb(this.zzec).removeMessages(1, (Object)this.zzeb);
            this.zzcz = iBinder;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzdz.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zze.zza(this.zzec);
        synchronized (hashMap) {
            zze.zzb(this.zzec).removeMessages(1, (Object)this.zzeb);
            this.zzcz = null;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzdz.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zze(String string2) {
        this.mState = 3;
        this.zzea = zze.zzd(this.zzec).zza(zze.zzc(this.zzec), string2, this.zzeb.zzb(zze.zzc(this.zzec)), this, this.zzeb.zzq());
        if (this.zzea) {
            Message message = zze.zzb(this.zzec).obtainMessage(1, (Object)this.zzeb);
            zze.zzb(this.zzec).sendMessageDelayed(message, zze.zze(this.zzec));
            return;
        }
        this.mState = 2;
        try {
            zze.zzd(this.zzec).unbindService(zze.zzc(this.zzec), this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzf(String string2) {
        zze.zzb(this.zzec).removeMessages(1, (Object)this.zzeb);
        zze.zzd(this.zzec).unbindService(zze.zzc(this.zzec), this);
        this.zzea = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zze.zzd(this.zzec);
        zze.zzc(this.zzec);
        this.zzeb.zzb(zze.zzc(this.zzec));
        this.zzdz.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zze.zzd(this.zzec);
        zze.zzc(this.zzec);
        this.zzdz.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zzea;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zzdz.contains(serviceConnection);
    }

    public final boolean zzr() {
        return this.zzdz.isEmpty();
    }

    public final int zzs() {
        return this.zzdz.size();
    }

    public final IBinder getBinder() {
        return this.zzcz;
    }

    public final ComponentName getComponentName() {
        return this.mComponentName;
    }
}

