/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamite;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.zzc;
import com.google.android.gms.dynamite.zzd;
import com.google.android.gms.dynamite.zze;
import com.google.android.gms.dynamite.zzf;
import com.google.android.gms.dynamite.zzg;
import com.google.android.gms.dynamite.zzh;
import com.google.android.gms.dynamite.zzi;
import com.google.android.gms.dynamite.zzj;
import com.google.android.gms.dynamite.zzk;
import com.google.android.gms.dynamite.zzl;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public final class DynamiteModule {
    @GuardedBy(value="DynamiteModule.class")
    private static Boolean zzid;
    @GuardedBy(value="DynamiteModule.class")
    private static zzi zzie;
    @GuardedBy(value="DynamiteModule.class")
    private static zzk zzif;
    @GuardedBy(value="DynamiteModule.class")
    private static String zzig;
    @GuardedBy(value="DynamiteModule.class")
    private static int zzih;
    private static final ThreadLocal<zza> zzii;
    private static final VersionPolicy.zza zzij;
    @KeepForSdk
    public static final VersionPolicy PREFER_REMOTE;
    private static final VersionPolicy zzik;
    @KeepForSdk
    public static final VersionPolicy PREFER_HIGHEST_OR_LOCAL_VERSION;
    @KeepForSdk
    public static final VersionPolicy PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING;
    @KeepForSdk
    public static final VersionPolicy PREFER_HIGHEST_OR_REMOTE_VERSION;
    private static final VersionPolicy zzil;
    private final Context zzim;

    /*
     * Loose catch block
     */
    @KeepForSdk
    public static DynamiteModule load(Context context, VersionPolicy versionPolicy, String string2) throws LoadingException {
        zza zza2 = zzii.get();
        zza zza3 = new zza(null);
        zzii.set(zza3);
        try {
            VersionPolicy.zzb zzb2 = versionPolicy.zza(context, string2, zzij);
            int n = zzb2.zziq;
            int n2 = zzb2.zzir;
            Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
            if (zzb2.zzis == 0 || zzb2.zzis == -1 && zzb2.zziq == 0 || zzb2.zzis == 1 && zzb2.zzir == 0) {
                n = zzb2.zziq;
                n2 = zzb2.zzir;
                throw new LoadingException(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString(), null);
            }
            if (zzb2.zzis == -1) {
                DynamiteModule dynamiteModule = DynamiteModule.zze(context, string2);
                return dynamiteModule;
            }
            if (zzb2.zzis == 1) {
                try {
                    DynamiteModule dynamiteModule = DynamiteModule.zza(context, string2, zzb2.zzir);
                    return dynamiteModule;
                }
                catch (LoadingException loadingException) {
                    block12: {
                        DynamiteModule dynamiteModule;
                        block13: {
                            String string3 = String.valueOf(loadingException.getMessage());
                            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                            if (zzb2.zziq == 0 || versionPolicy.zza((Context)context, (String)string2, (VersionPolicy.zza)new zzb((int)zzb2.zziq, (int)0)).zzis != -1) break block12;
                            dynamiteModule = DynamiteModule.zze(context, string2);
                            if (zza3.zzin == null) break block13;
                            zza3.zzin.close();
                        }
                        zzii.set(zza2);
                        return dynamiteModule;
                    }
                    throw new LoadingException("Remote load failed. No local fallback found.", loadingException, null);
                }
            }
            n = zzb2.zzis;
            throw new LoadingException(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString(), null);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (zza3.zzin != null) {
                zza3.zzin.close();
            }
            zzii.set(zza2);
        }
    }

    @KeepForSdk
    public static int getLocalVersion(Context context, String string2) {
        try {
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(61 + String.valueOf(string2).length()).append("com.google.android.gms.dynamite.descriptors.").append(string2).append(".ModuleDescriptor").toString());
            Field field = clazz.getDeclaredField("MODULE_ID");
            Field field2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!field.get(null).equals(string2)) {
                String string3 = String.valueOf(field.get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return field2.getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int zza(Context context, String string2, boolean bl) {
        try {
            Class<DynamiteModule> clazz = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                Boolean bl2 = zzid;
                if (bl2 == null) {
                    try {
                        Class<?> clazz2 = context.getApplicationContext().getClassLoader().loadClass(DynamiteLoaderClassLoader.class.getName());
                        Field field = clazz2.getDeclaredField("sClassLoader");
                        Class<?> clazz3 = clazz2;
                        synchronized (clazz3) {
                            Object object = (ClassLoader)field.get(null);
                            if (object != null) {
                                if (object == ClassLoader.getSystemClassLoader()) {
                                    bl2 = Boolean.FALSE;
                                } else {
                                    try {
                                        DynamiteModule.zza(object);
                                    }
                                    catch (LoadingException loadingException) {}
                                    bl2 = Boolean.TRUE;
                                }
                            } else if ("com.google.android.gms".equals(context.getApplicationContext().getPackageName())) {
                                field.set(null, ClassLoader.getSystemClassLoader());
                                bl2 = Boolean.FALSE;
                            } else {
                                try {
                                    int n = DynamiteModule.zzc(context, string2, bl);
                                    if (zzig == null || zzig.isEmpty()) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 2, 18, 3, 5, 22, 7, 24, 8] lbl31 : MonitorExitStatement: MONITOREXIT : var8_10
                                        // ** MonitorExit[var4_3] (shouldn't be in output)
                                        return n;
                                    }
                                    object = new zzh(zzig, ClassLoader.getSystemClassLoader());
                                    DynamiteModule.zza(object);
                                    field.set(null, object);
                                    zzid = Boolean.TRUE;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 18, 3, 5, 22, 7, 24, 8] lbl38 : MonitorExitStatement: MONITOREXIT : var8_10
                                    // ** MonitorExit[var4_3] (shouldn't be in output)
                                    return n;
                                }
                                catch (LoadingException loadingException) {
                                    field.set(null, ClassLoader.getSystemClassLoader());
                                    bl2 = Boolean.FALSE;
                                }
                            }
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                        String string3 = String.valueOf(reflectiveOperationException);
                        Log.w((String)"DynamiteModule", (String)new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to load module via V2: ").append(string3).toString());
                        bl2 = Boolean.FALSE;
                    }
                    zzid = bl2;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (bl2.booleanValue()) {
                    try {
                        return DynamiteModule.zzc(context, string2, bl);
                    }
                    catch (LoadingException loadingException) {
                        String string4 = String.valueOf(loadingException.getMessage());
                        Log.w((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to retrieve remote module version: ".concat(string4) : new String("Failed to retrieve remote module version: ")));
                        return 0;
                    }
                }
                return DynamiteModule.zzb(context, string2, bl);
            }
        }
        catch (Throwable throwable) {
            CrashUtils.addDynamiteErrorToDropBox(context, throwable);
            throw throwable;
        }
    }

    private static int zzb(Context context, String string2, boolean bl) {
        zzi zzi2 = DynamiteModule.zzj(context);
        if (zzi2 == null) {
            return 0;
        }
        try {
            if (zzi2.zzaj() >= 2) {
                return zzi2.zzb(ObjectWrapper.wrap(context), string2, bl);
            }
            Log.w((String)"DynamiteModule", (String)"IDynamite loader version < 2, falling back to getModuleVersion2");
            return zzi2.zza(ObjectWrapper.wrap(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int zzc(Context context, String string2, boolean bl) throws LoadingException {
        try (Cursor cursor = null;){
            boolean bl2 = bl;
            String string3 = string2;
            boolean bl3 = bl2;
            String string4 = string3;
            String string5 = bl3 ? "api_force_staging" : "api";
            cursor = context.getContentResolver().query(Uri.parse((String)new StringBuilder(42 + String.valueOf(string5).length() + String.valueOf(string4).length()).append("content://com.google.android.gms.chimera/").append(string5).append("/").append(string4).toString()), null, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new LoadingException("Failed to connect to dynamite module ContentResolver.", null);
            }
            int n = cursor.getInt(0);
            if (n <= 0) return n;
            Object object = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                zzig = cursor.getString(2);
                int n2 = cursor.getColumnIndex("loaderVersion");
                if (n2 >= 0) {
                    zzih = cursor.getInt(n2);
                }
                // ** MonitorExit[var5_11] (shouldn't be in output)
                object = zzii.get();
                if (object == null || ((zza)object).zzin != null) return n;
                ((zza)object).zzin = cursor;
                cursor = null;
                return n;
            }
        }
    }

    @KeepForSdk
    public static int getRemoteVersion(Context context, String string2) {
        return DynamiteModule.zza(context, string2, false);
    }

    private static DynamiteModule zze(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new DynamiteModule(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zza(Context context, String string2, int n) throws LoadingException {
        try {
            Class<DynamiteModule> clazz = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                Boolean bl = zzid;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (bl == null) {
                    throw new LoadingException("Failed to determine which loading route to use.", null);
                }
                if (bl.booleanValue()) {
                    return DynamiteModule.zzc(context, string2, n);
                }
                return DynamiteModule.zzb(context, string2, n);
            }
        }
        catch (Throwable throwable) {
            CrashUtils.addDynamiteErrorToDropBox(context, throwable);
            throw throwable;
        }
    }

    private static DynamiteModule zzb(Context context, String string2, int n) throws LoadingException {
        IObjectWrapper iObjectWrapper;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        zzi zzi2 = DynamiteModule.zzj(context);
        if (zzi2 == null) {
            throw new LoadingException("Failed to create IDynamiteLoader.", null);
        }
        try {
            if (zzi2.zzaj() >= 2) {
                iObjectWrapper = zzi2.zzb(ObjectWrapper.wrap(context), string2, n);
            } else {
                Log.w((String)"DynamiteModule", (String)"Dynamite loader version < 2, falling back to createModuleContext");
                iObjectWrapper = zzi2.zza(ObjectWrapper.wrap(context), string2, n);
            }
        }
        catch (RemoteException remoteException) {
            throw new LoadingException("Failed to load remote module.", remoteException, null);
        }
        if (ObjectWrapper.unwrap(iObjectWrapper) == null) {
            throw new LoadingException("Failed to load remote module.", null);
        }
        return new DynamiteModule((Context)ObjectWrapper.unwrap(iObjectWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzi zzj(Context context) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            if (zzie != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zzie;
            }
            if (GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            try {
                IInterface iInterface;
                zzi zzi2;
                IBinder iBinder = (IBinder)context.createPackageContext("com.google.android.gms", 3).getClassLoader().loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl").newInstance();
                if ((iBinder == null ? null : (zzi2 = (iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoader")) instanceof zzi ? (zzi)iInterface : new zzj(iBinder))) != null) {
                    zzie = zzi2;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return zzi2;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    @KeepForSdk
    public final Context getModuleContext() {
        return this.zzim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zzc(Context context, String string2, int n) throws LoadingException {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Object object = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            zzk zzk2 = zzif;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (zzk2 == null) {
                throw new LoadingException("DynamiteLoaderV2 was not cached.", null);
            }
            object = zzii.get();
            if (object == null || ((zza)object).zzin == null) {
                throw new LoadingException("No result cursor", null);
            }
            Context context2 = DynamiteModule.zza(context.getApplicationContext(), string2, n, ((zza)object).zzin, zzk2);
            if (context2 == null) {
                throw new LoadingException("Failed to get module context", null);
            }
            return new DynamiteModule(context2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean zzai() {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzih >= 2;
        }
    }

    private static Context zza(Context context, String string2, int n, Cursor cursor, zzk zzk2) {
        try {
            IObjectWrapper iObjectWrapper;
            ObjectWrapper.wrap(null);
            if (DynamiteModule.zzai().booleanValue()) {
                Log.v((String)"DynamiteModule", (String)"Dynamite loader version >= 2, using loadModule2NoCrashUtils");
                iObjectWrapper = zzk2.zzb(ObjectWrapper.wrap(context), string2, n, ObjectWrapper.wrap(cursor));
            } else {
                Log.w((String)"DynamiteModule", (String)"Dynamite loader version < 2, falling back to loadModule2");
                iObjectWrapper = zzk2.zza(ObjectWrapper.wrap(context), string2, n, ObjectWrapper.wrap(cursor));
            }
            return (Context)ObjectWrapper.unwrap(iObjectWrapper);
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception.toString());
            Log.e((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load DynamiteLoader: ".concat(string3) : new String("Failed to load DynamiteLoader: ")));
            return null;
        }
    }

    @GuardedBy(value="DynamiteModule.class")
    private static void zza(ClassLoader classLoader) throws LoadingException {
        try {
            IInterface iInterface;
            IBinder iBinder = (IBinder)classLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]);
            zzif = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoaderV2")) instanceof zzk ? (zzk)iInterface : new zzl(iBinder));
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new LoadingException("Failed to instantiate dynamite loader", reflectiveOperationException, null);
        }
    }

    @KeepForSdk
    public final IBinder instantiate(String string2) throws LoadingException {
        try {
            return (IBinder)this.zzim.getClassLoader().loadClass(string2).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new LoadingException(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException, null);
        }
    }

    private DynamiteModule(Context context) {
        this.zzim = Preconditions.checkNotNull(context);
    }

    static {
        zzih = -1;
        zzii = new ThreadLocal();
        zzij = new com.google.android.gms.dynamite.zza();
        PREFER_REMOTE = new com.google.android.gms.dynamite.zzb();
        zzik = new zzc();
        PREFER_HIGHEST_OR_LOCAL_VERSION = new zzd();
        PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING = new zze();
        PREFER_HIGHEST_OR_REMOTE_VERSION = new zzf();
        zzil = new zzg();
    }

    @DynamiteApi
    public static class DynamiteLoaderClassLoader {
        @GuardedBy(value="DynamiteLoaderClassLoader.class")
        public static ClassLoader sClassLoader;

        public DynamiteLoaderClassLoader() {
        }
    }

    private static final class zza {
        public Cursor zzin;

        private zza() {
        }

        /* synthetic */ zza(com.google.android.gms.dynamite.zza zza2) {
            this();
        }
    }

    @KeepForSdk
    public static class LoadingException
    extends Exception {
        private LoadingException(String string2) {
            super(string2);
        }

        private LoadingException(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        /* synthetic */ LoadingException(String string2, com.google.android.gms.dynamite.zza zza2) {
            this(string2);
        }

        /* synthetic */ LoadingException(String string2, Throwable throwable, com.google.android.gms.dynamite.zza zza2) {
            this(string2, throwable);
        }
    }

    private static final class zzb
    implements VersionPolicy.zza {
        private final int zzio;
        private final int zzip;

        public zzb(int n, int n2) {
            this.zzio = n;
            this.zzip = 0;
        }

        @Override
        public final int zza(Context context, String string2, boolean bl) {
            return 0;
        }

        @Override
        public final int getLocalVersion(Context context, String string2) {
            return this.zzio;
        }
    }

    public static interface VersionPolicy {
        public zzb zza(Context var1, String var2, zza var3) throws LoadingException;

        public static final class zzb {
            public int zziq = 0;
            public int zzir = 0;
            public int zzis = 0;
        }

        public static interface zza {
            public int zza(Context var1, String var2, boolean var3) throws LoadingException;

            public int getLocalVersion(Context var1, String var2);
        }
    }
}

