/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

public class InputMethodUtils {
    private InputMethodUtils() {
    }

    private static InputMethodManager zzf(Context context) {
        return (InputMethodManager)context.getSystemService("input_method");
    }

    public static boolean showSoftInput(Context context, View view) {
        InputMethodManager inputMethodManager = InputMethodUtils.zzf(context);
        if (inputMethodManager != null) {
            inputMethodManager.showSoftInput(view, 0);
            return true;
        }
        return false;
    }

    public static boolean hideSoftInput(Context context, View view) {
        InputMethodManager inputMethodManager = InputMethodUtils.zzf(context);
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
            return true;
        }
        return false;
    }

    public static void restart(Context context, View view) {
        InputMethodManager inputMethodManager = InputMethodUtils.zzf(context);
        if (inputMethodManager != null) {
            inputMethodManager.restartInput(view);
        }
    }

    public static boolean isAcceptingText(Context context) {
        InputMethodManager inputMethodManager = InputMethodUtils.zzf(context);
        if (inputMethodManager != null) {
            return inputMethodManager.isAcceptingText();
        }
        return false;
    }
}

