/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GmsVersionParser {
    private static Pattern zzzy = null;
    public static final int UNKNOWN = -1;

    private static Pattern zzdc() {
        if (zzzy == null) {
            zzzy = Pattern.compile("\\((?:eng-)?(\\d+)-(.+?)[-)$]");
        }
        return zzzy;
    }

    public static long parseBuildNumber(String string2) {
        if (string2 == null) {
            return -1L;
        }
        Matcher matcher = GmsVersionParser.zzdc().matcher(string2);
        if (matcher.find()) {
            String string3 = matcher.group(2);
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1L;
    }

    public static long parseVariantCode(String string2) {
        if (string2 == null) {
            return -1L;
        }
        Matcher matcher = GmsVersionParser.zzdc().matcher(string2);
        if (matcher.find()) {
            String string3 = matcher.group(1);
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1L;
    }

    public static int parseBuildVersion(int n) {
        if (n == -1) {
            return -1;
        }
        return n / 1000;
    }

    public static int parseBuildMajorVersion(int n) {
        if (n == -1) {
            return -1;
        }
        return n / 100000;
    }

    public static int parseBuildType(String string2) {
        long l = GmsVersionParser.parseVariantCode(string2);
        if (l == -1L) {
            return -1;
        }
        return (int)(l / 10000L);
    }

    public static int parseTargetArchitecture(String string2) {
        long l = GmsVersionParser.parseVariantCode(string2);
        if (l == -1L) {
            return -1;
        }
        return (int)(l / 100L % 100L);
    }

    public static int parseScreenDensity(String string2) {
        long l = GmsVersionParser.parseVariantCode(string2);
        if (l == -1L) {
            return -1;
        }
        return (int)(l % 100L);
    }

    private GmsVersionParser() {
    }
}

