/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

@VisibleForTesting
public final class ArrayUtils {
    public static <T> int indexOf(T[] TArray, T t) {
        int n = TArray != null ? TArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!Objects.equal(TArray[i], t)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] TArray, T t) {
        return ArrayUtils.indexOf(TArray, t) >= 0;
    }

    public static boolean contains(byte[] byArray, byte by) {
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = byArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] != by) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(boolean[] blArray, boolean bl) {
        if (blArray == null) {
            return false;
        }
        boolean[] blArray2 = blArray;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (blArray2[i] != bl) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] cArray, char c) {
        if (cArray == null) {
            return false;
        }
        char[] cArray2 = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray2[i] != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] sArray, short s) {
        if (sArray == null) {
            return false;
        }
        short[] sArray2 = sArray;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            if (sArray2[i] != s) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray2[i] != n) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] dArray, double d) {
        if (dArray == null) {
            return false;
        }
        double[] dArray2 = dArray;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (dArray2[i] != d) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(float[] fArray, float f, float f2) {
        if (fArray == null) {
            return false;
        }
        float f3 = f - f2;
        float f4 = f + f2;
        float[] fArray2 = fArray;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f5 = fArray2[i];
            if (!(f3 <= f5) || !(f5 <= f4)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] stringArray, String string2) {
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray2[i];
            if (string3 == string2) {
                return true;
            }
            if (string3 == null || !string3.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyOrder(Object[] objectArray, Object[] objectArray2) {
        Object object;
        int n;
        int n2;
        if (objectArray == objectArray2) {
            return true;
        }
        int n3 = objectArray == null ? 0 : objectArray.length;
        int n4 = n2 = objectArray2 == null ? 0 : objectArray2.length;
        if (n3 == 0 && n2 == 0) {
            return true;
        }
        if (n3 != n2) {
            return false;
        }
        zza zza2 = new zza(n3);
        Object[] objectArray3 = objectArray;
        int n5 = objectArray.length;
        for (n = 0; n < n5; ++n) {
            object = objectArray3[n];
            zza2.zzb(object);
        }
        objectArray3 = objectArray2;
        n5 = objectArray2.length;
        for (n = 0; n < n5; ++n) {
            object = objectArray3[n];
            zza2.zzc(object);
        }
        Iterator<com.google.android.gms.common.util.zza> iterator = zza2.zzzb.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().count == 0) continue;
            return false;
        }
        return true;
    }

    public static Integer[] toWrapperArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static Character[] toWrapperArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        Character[] characterArray = new Character[n];
        for (int i = 0; i < n; ++i) {
            characterArray[i] = Character.valueOf(cArray[i]);
        }
        return characterArray;
    }

    public static Long[] toWrapperArray(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        Long[] longArray = new Long[n];
        for (int i = 0; i < n; ++i) {
            longArray[i] = lArray[i];
        }
        return longArray;
    }

    public static Double[] toWrapperArray(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        Double[] doubleArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    public static Float[] toWrapperArray(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        Float[] floatArray = new Float[n];
        for (int i = 0; i < n; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        return floatArray;
    }

    public static Byte[] toWrapperArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        Byte[] byteArray = new Byte[n];
        for (int i = 0; i < n; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public static Boolean[] toWrapperArray(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        Boolean[] booleanArray = new Boolean[n];
        for (int i = 0; i < n; ++i) {
            booleanArray[i] = blArray[i];
        }
        return booleanArray;
    }

    public static Short[] toWrapperArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        Short[] shortArray = new Short[n];
        for (int i = 0; i < n; ++i) {
            shortArray[i] = sArray[i];
        }
        return shortArray;
    }

    private ArrayUtils() {
    }

    public static <T> void writeArray(StringBuilder stringBuilder, T[] TArray) {
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(TArray[i].toString());
        }
    }

    public static void writeArray(StringBuilder stringBuilder, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(nArray[i]));
        }
    }

    public static void writeArray(StringBuilder stringBuilder, long[] lArray) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Long.toString(lArray[i]));
        }
    }

    public static void writeArray(StringBuilder stringBuilder, float[] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Float.toString(fArray[i]));
        }
    }

    public static void writeArray(StringBuilder stringBuilder, double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Double.toString(dArray[i]));
        }
    }

    public static void writeArray(StringBuilder stringBuilder, boolean[] blArray) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Boolean.toString(blArray[i]));
        }
    }

    public static void writeStringArray(StringBuilder stringBuilder, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(stringArray[i]).append("\"");
        }
    }

    public static <T> T[] concat(T[] ... TArray) {
        if (TArray.length == 0) {
            return (Object[])Array.newInstance(TArray.getClass(), 0);
        }
        int n = 0;
        for (int i = 0; i < TArray.length; ++i) {
            n += TArray[i].length;
        }
        T[] TArray2 = Arrays.copyOf(TArray[0], n);
        int n2 = TArray[0].length;
        for (int i = 1; i < TArray.length; ++i) {
            T[] TArray3 = TArray[i];
            System.arraycopy(TArray3, 0, TArray2, n2, TArray3.length);
            n2 += TArray3.length;
        }
        return TArray2;
    }

    public static byte[] concatByteArrays(byte[] ... byArray) {
        if (byArray.length == 0) {
            return new byte[0];
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i].length;
        }
        byte[] byArray2 = Arrays.copyOf(byArray[0], n);
        int n2 = byArray[0].length;
        for (int i = 1; i < byArray.length; ++i) {
            byte[] byArray3 = byArray[i];
            System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
            n2 += byArray3.length;
        }
        return byArray2;
    }

    public static <T> T[] appendToArray(T[] TArray, T t) {
        if (TArray == null && t == null) {
            throw new IllegalArgumentException("Cannot generate array of generic type w/o class info");
        }
        Object[] objectArray = TArray == null ? (Object[])Array.newInstance(t.getClass(), 1) : Arrays.copyOf(TArray, TArray.length + 1);
        objectArray[objectArray.length - 1] = t;
        return objectArray;
    }

    public static int[] appendToArray(int[] nArray, int n) {
        int[] nArray2 = nArray == null || nArray.length == 0 ? new int[1] : Arrays.copyOf(nArray, nArray.length + 1);
        nArray2[nArray2.length - 1] = n;
        return nArray2;
    }

    public static <T> T[] removeAll(T[] TArray, T ... TArray2) {
        if (TArray == null) {
            return null;
        }
        if (TArray2 == null || TArray2.length == 0) {
            return Arrays.copyOf(TArray, TArray.length);
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray2.getClass().getComponentType(), TArray.length);
        int n = 0;
        if (TArray2.length == 1) {
            T[] TArray3 = TArray;
            int n2 = TArray.length;
            for (int i = 0; i < n2; ++i) {
                T t = TArray3[i];
                if (Objects.equal(TArray2[0], t)) continue;
                objectArray[n++] = t;
            }
        } else {
            T[] TArray4 = TArray;
            int n3 = TArray.length;
            for (int i = 0; i < n3; ++i) {
                T t = TArray4[i];
                if (ArrayUtils.contains(TArray2, t)) continue;
                objectArray[n++] = t;
            }
        }
        return ArrayUtils.resize(objectArray, n);
    }

    public static int[] removeAll(int[] nArray, int ... nArray2) {
        if (nArray == null) {
            return null;
        }
        if (nArray2 == null || nArray2.length == 0) {
            return Arrays.copyOf(nArray, nArray.length);
        }
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        if (nArray2.length == 1) {
            int[] nArray4 = nArray;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray4[i];
                if (nArray2[0] == n3) continue;
                nArray3[n++] = n3;
            }
        } else {
            int[] nArray5 = nArray;
            int n4 = nArray.length;
            for (int i = 0; i < n4; ++i) {
                int n5 = nArray5[i];
                if (ArrayUtils.contains(nArray2, n5)) continue;
                nArray3[n++] = n5;
            }
        }
        return ArrayUtils.resize(nArray3, n);
    }

    public static <T> T[] resize(T[] TArray, int n) {
        if (TArray == null) {
            return null;
        }
        T[] TArray2 = TArray;
        if (n != TArray.length) {
            TArray2 = Arrays.copyOf(TArray, n);
        }
        return TArray2;
    }

    public static int[] resize(int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = nArray;
        if (n != nArray.length) {
            nArray2 = Arrays.copyOf(nArray, n);
        }
        return nArray2;
    }

    public static <T> int rearrange(T[] TArray, Predicate<T> predicate) {
        if (TArray == null || TArray.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = TArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!predicate.apply(TArray[i])) continue;
            if (n != i) {
                T t = TArray[n];
                TArray[n] = TArray[i];
                TArray[i] = t;
            }
            ++n;
        }
        return n;
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> toArrayList(T[] TArray) {
        int n = TArray.length;
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(TArray[i]);
        }
        return arrayList;
    }

    public static <T> ArrayList<T> toArrayList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static int[] toPrimitiveArray(Collection<Integer> collection) {
        if (collection == null || collection.size() == 0) {
            return new int[0];
        }
        int n = 0;
        int[] nArray = new int[collection.size()];
        for (Integer n2 : collection) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static int[] toPrimitiveArray(Integer[] integerArray) {
        if (integerArray == null) {
            return new int[0];
        }
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public static long[] toLongArray(Collection<Long> collection) {
        if (collection == null || collection.size() == 0) {
            return new long[0];
        }
        int n = 0;
        long[] lArray = new long[collection.size()];
        for (Long l : collection) {
            lArray[n++] = l;
        }
        return lArray;
    }

    public static long[] toLongArray(Long[] longArray) {
        if (longArray == null) {
            return new long[0];
        }
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            lArray[i] = longArray[i];
        }
        return lArray;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null || collection.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[collection.size()];
        return collection.toArray(stringArray);
    }

    private static final class zza {
        HashMap<Object, com.google.android.gms.common.util.zza> zzzb;

        zza(int n) {
            this.zzzb = new HashMap(n);
        }

        final void zzb(Object object) {
            ++this.zzd((Object)object).count;
        }

        final void zzc(Object object) {
            --this.zzd((Object)object).count;
        }

        private final com.google.android.gms.common.util.zza zzd(Object object) {
            com.google.android.gms.common.util.zza zza2 = this.zzzb.get(object);
            if (zza2 == null) {
                zza2 = new com.google.android.gms.common.util.zza();
                this.zzzb.put(object, zza2);
            }
            return zza2;
        }
    }
}

