/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.stats.StatsEvent;
import com.google.android.gms.common.stats.WakeLockEventCreator;
import java.util.List;
import javax.annotation.Nullable;

@SafeParcelable.Class(creator="WakeLockEventCreator")
public final class WakeLockEvent
extends StatsEvent {
    public static final Parcelable.Creator<WakeLockEvent> CREATOR = new WakeLockEventCreator();
    @SafeParcelable.VersionField(id=1)
    private final int zzal;
    @SafeParcelable.Field(id=2, getter="getTimeMillis")
    private final long zzxv;
    @SafeParcelable.Field(id=11, getter="getEventType")
    private int zzxw;
    @SafeParcelable.Field(id=4, getter="getWakeLockName")
    private final String zzyq;
    @SafeParcelable.Field(id=10, getter="getSecondaryWakeLockName")
    private final String zzyr;
    @SafeParcelable.Field(id=17, getter="getCodePackage")
    private final String zzys;
    @SafeParcelable.Field(id=5, getter="getWakeLockType")
    private final int zzyt;
    @SafeParcelable.Field(id=6, getter="getCallingPackages")
    private final List<String> zzyu;
    @SafeParcelable.Field(id=12, getter="getEventKey")
    private final String zzyv;
    @SafeParcelable.Field(id=8, getter="getElapsedRealtime")
    private final long zzyd;
    @SafeParcelable.Field(id=14, getter="getDeviceState")
    private int zzyw;
    @SafeParcelable.Field(id=13, getter="getHostPackage")
    private final String zzyx;
    @SafeParcelable.Field(id=15, getter="getBeginPowerPercentage")
    private final float zzyy;
    @SafeParcelable.Field(id=16, getter="getTimeout")
    private final long mTimeout;
    private long zzyf;

    @SafeParcelable.Constructor
    WakeLockEvent(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=11) int n2, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) int n3, @SafeParcelable.Param(id=6) List<String> list, @SafeParcelable.Param(id=12) String string3, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=14) int n4, @SafeParcelable.Param(id=10) String string4, @SafeParcelable.Param(id=13) String string5, @SafeParcelable.Param(id=15) float f, @SafeParcelable.Param(id=16) long l3, @SafeParcelable.Param(id=17) String string6) {
        this.zzal = n;
        this.zzxv = l;
        this.zzxw = n2;
        this.zzyq = string2;
        this.zzyr = string4;
        this.zzys = string6;
        this.zzyt = n3;
        this.zzyf = -1L;
        this.zzyu = list;
        this.zzyv = string3;
        this.zzyd = l2;
        this.zzyw = n4;
        this.zzyx = string5;
        this.zzyy = f;
        this.mTimeout = l3;
    }

    public WakeLockEvent(long l, int n, String string2, int n2, List<String> list, String string3, long l2, int n3, String string4, String string5, float f, long l3, String string6) {
        this(2, l, n, string2, n2, list, string3, l2, n3, string4, string5, f, l3, string6);
    }

    public WakeLockEvent(WakeLockEvent wakeLockEvent) {
        this(wakeLockEvent.zzal, ((StatsEvent)wakeLockEvent).getTimeMillis(), ((StatsEvent)wakeLockEvent).getEventType(), wakeLockEvent.getWakeLockName(), wakeLockEvent.getWakeLockType(), wakeLockEvent.getCallingPackages(), ((StatsEvent)wakeLockEvent).getEventKey(), ((StatsEvent)wakeLockEvent).getElapsedRealtime(), wakeLockEvent.getDeviceState(), wakeLockEvent.getSecondaryWakeLockName(), wakeLockEvent.getHostPackage(), wakeLockEvent.getBeginPowerPercentage(), ((StatsEvent)wakeLockEvent).getTimeout(), wakeLockEvent.getCodePackage());
    }

    @Override
    public final long getTimeMillis() {
        return this.zzxv;
    }

    @Override
    public final int getEventType() {
        return this.zzxw;
    }

    @Override
    public final StatsEvent setEventType(int n) {
        this.zzxw = n;
        return this;
    }

    public final String getWakeLockName() {
        return this.zzyq;
    }

    public final String getSecondaryWakeLockName() {
        return this.zzyr;
    }

    public final String getCodePackage() {
        return this.zzys;
    }

    public final int getWakeLockType() {
        return this.zzyt;
    }

    @Nullable
    public final List<String> getCallingPackages() {
        return this.zzyu;
    }

    @Override
    public final String getEventKey() {
        return this.zzyv;
    }

    @Override
    public final long getDurationMillis() {
        return this.zzyf;
    }

    @Override
    public final StatsEvent setDurationMillis(long l) {
        this.zzyf = l;
        return this;
    }

    @Override
    public final long getElapsedRealtime() {
        return this.zzyd;
    }

    @Override
    public final StatsEvent ReconstructCloseEvent(StatsEvent statsEvent) {
        if (statsEvent instanceof WakeLockEvent) {
            WakeLockEvent wakeLockEvent = (WakeLockEvent)statsEvent;
            return ((StatsEvent)new WakeLockEvent(wakeLockEvent)).setEventType(((StatsEvent)this).getEventType()).setDurationMillis(((StatsEvent)this).getElapsedRealtime() - ((StatsEvent)wakeLockEvent).getElapsedRealtime());
        }
        return statsEvent;
    }

    public final int getDeviceState() {
        return this.zzyw;
    }

    public final String getHostPackage() {
        return this.zzyx;
    }

    public final float getBeginPowerPercentage() {
        return this.zzyy;
    }

    @Override
    public final long getTimeout() {
        return this.mTimeout;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WakeLockEvent wakeLockEvent = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, wakeLockEvent.zzal);
        SafeParcelWriter.writeLong(parcel2, 2, ((StatsEvent)wakeLockEvent).getTimeMillis());
        SafeParcelWriter.writeString(parcel2, 4, wakeLockEvent.getWakeLockName(), false);
        SafeParcelWriter.writeInt(parcel2, 5, wakeLockEvent.getWakeLockType());
        SafeParcelWriter.writeStringList(parcel2, 6, wakeLockEvent.getCallingPackages(), false);
        SafeParcelWriter.writeLong(parcel2, 8, ((StatsEvent)wakeLockEvent).getElapsedRealtime());
        SafeParcelWriter.writeString(parcel2, 10, wakeLockEvent.getSecondaryWakeLockName(), false);
        SafeParcelWriter.writeInt(parcel2, 11, ((StatsEvent)wakeLockEvent).getEventType());
        SafeParcelWriter.writeString(parcel2, 12, ((StatsEvent)wakeLockEvent).getEventKey(), false);
        SafeParcelWriter.writeString(parcel2, 13, wakeLockEvent.getHostPackage(), false);
        SafeParcelWriter.writeInt(parcel2, 14, wakeLockEvent.getDeviceState());
        SafeParcelWriter.writeFloat(parcel2, 15, wakeLockEvent.getBeginPowerPercentage());
        SafeParcelWriter.writeLong(parcel2, 16, ((StatsEvent)wakeLockEvent).getTimeout());
        SafeParcelWriter.writeString(parcel2, 17, wakeLockEvent.getCodePackage(), false);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    @Override
    public final String getSpecificString() {
        String string2 = this.getWakeLockName();
        int n = this.getWakeLockType();
        String string3 = this.getCallingPackages() == null ? "" : TextUtils.join((CharSequence)",", this.getCallingPackages());
        int n2 = this.getDeviceState();
        String string4 = this.getSecondaryWakeLockName() == null ? "" : this.getSecondaryWakeLockName();
        String string5 = this.getHostPackage() == null ? "" : this.getHostPackage();
        float f = this.getBeginPowerPercentage();
        String string6 = this.getCodePackage() == null ? "" : this.getCodePackage();
        return new StringBuilder(45 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("\t").append(string2).append("\t").append(n).append("\t").append(string3).append("\t").append(n2).append("\t").append(string4).append("\t").append(string5).append("\t").append(f).append("\t").append(string6).toString();
    }

    @Override
    public final WakeLockEvent markTimeOut() {
        if (this.mTimeout != 0L) {
            this.zzyf = this.mTimeout;
        }
        if (7 == this.zzxw) {
            this.zzxw = 9;
        } else if (10 == this.zzxw) {
            this.zzxw = 12;
        }
        return this;
    }

    public static boolean checkEventType(StatsEvent statsEvent) {
        return 7 == statsEvent.getEventType() || 8 == statsEvent.getEventType() || 9 == statsEvent.getEventType() || 10 == statsEvent.getEventType() || 11 == statsEvent.getEventType() || 12 == statsEvent.getEventType();
    }
}

