/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import javax.annotation.concurrent.GuardedBy;

public class MetadataValueReader {
    public static final String KEY_METADATA_APP_ID = "com.google.app.id";
    private static Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static boolean zzui;
    private static String zzuj;
    private static int zzuk;

    public MetadataValueReader() {
    }

    public static String getGoogleAppId(Context context) {
        MetadataValueReader.zze(context);
        return zzuj;
    }

    public static int getGooglePlayServicesVersion(Context context) {
        MetadataValueReader.zze(context);
        return zzuk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void resetForTesting() {
        Object object = sLock;
        synchronized (object) {
            zzui = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void setValuesForTesting(String string2, int n) {
        Object object = sLock;
        synchronized (object) {
            zzuj = string2;
            zzuk = n;
            zzui = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zze(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzui) {
                return;
            }
            zzui = true;
            String string2 = context.getPackageName();
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager(context);
            try {
                Bundle bundle = packageManagerWrapper.getApplicationInfo((String)string2, (int)128).metaData;
                if (bundle == null) {
                    return;
                }
                zzuj = bundle.getString(KEY_METADATA_APP_ID);
                zzuk = bundle.getInt("com.google.android.gms.version");
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"MetadataValueReader", (String)"This should never happen.", (Throwable)nameNotFoundException);
            }
            return;
        }
    }
}

