/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.ShareCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.AccountPicker;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.api.Scope;
import java.util.Locale;

public class GmsIntents {
    private static final Uri zztz = Uri.parse((String)"https://plus.google.com/");
    private static final Uri zzua = zztz.buildUpon().appendPath("circles").appendPath("find").build();
    public static final String ACTION_SET_GMS_ACCOUNT = "com.google.android.gms.common.SET_GMS_ACCOUNT";
    public static final String EXTRA_SET_GMS_ACCOUNT_NAME = "ACCOUNT_NAME";
    public static final String EXTRA_SET_GMS_ACCOUNT_PACKAGE_NAME = "PACKAGE_NAME";
    public static final String PERMISSION_GMS_INTERNAL_BROADCAST = "com.google.android.gms.permission.INTERNAL_BROADCAST";
    public static final String BROADCAST_CIRCLES_CHANGED = "com.google.android.gms.people.BROADCAST_CIRCLES_CHANGED";
    public static final String COMMON_SIGN_IN_EXTRA_PACKAGE_NAME = "SIGN_IN_PACKAGE_NAME";
    public static final String COMMON_SIGN_IN_EXTRA_SCOPE_ARRAY = "SIGN_IN_SCOPE_ARRAY";
    public static final String COMMON_SIGN_IN_EXTRA_SAVE_DEFAULT_ACCOUNT = "SIGN_IN_SAVE_DEFAULT_ACCOUNT";
    public static final String GOOGLE_NOW_PACKAGE_NAME = "com.google.android.googlequicksearchbox";
    public static final String ACTION_UDC_SETTING_CHANGED = "com.google.android.gms.udc.action.SETTING_CHANGED";
    public static final String EXTRA_UDC_ACCOUNT_NAME = "com.google.android.gms.udc.extra.accountName";
    public static final String EXTRA_UDC_SETTING_ID_LIST = "com.google.android.gms.udc.extra.settingIdList";
    public static final String ACTION_ICING_CONTACT_CHANGED = "com.google.android.gms.icing.action.CONTACT_CHANGED";
    public static final String EXTRA_ICING_CONTACT_CHANGED_IS_SIGNIFICANT = "com.google.android.gms.icing.extra.isSignificant";
    public static final String ACTION_FITNESS_APP_DISCONNECTED = "com.google.android.gms.fitness.app_disconnected";
    public static final String MIME_ACTIVITY_DISCONNECT_TYPE = "vnd.google.android.fitness/app_disconnect";
    public static final String EXTRA_APP = "com.google.android.gms.fitness.disconnected_app";
    public static final String EXTRA_ACCOUNT = "com.google.android.gms.fitness.disconnected_account";

    private GmsIntents() {
    }

    public static Intent createSettingsIntent(String string2) {
        Uri uri = Uri.fromParts((String)"package", (String)string2, null);
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(uri);
        return intent;
    }

    public static Intent createDateSettingsIntent() {
        return new Intent("android.settings.DATE_SETTINGS");
    }

    public static Uri getPlayStoreUri(String string2) {
        return Uri.parse((String)"https://play.google.com/store/apps/details").buildUpon().appendQueryParameter("id", string2).build();
    }

    public static Intent createPlayStoreIntent(String string2) {
        return GmsIntents.createPlayStoreIntent(string2, null);
    }

    public static Intent createPlayStoreIntent(String string2, @Nullable String string3) {
        Intent intent = new Intent("android.intent.action.VIEW");
        String string4 = string3;
        String string5 = string2;
        Uri.Builder builder = Uri.parse((String)"market://details").buildUpon().appendQueryParameter("id", string5);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            builder.appendQueryParameter("pcampaignid", string4);
        }
        intent.setData(builder.build());
        intent.setPackage("com.android.vending");
        intent.addFlags(524288);
        return intent;
    }

    public static Intent createPlayStoreLightPurchaseFlowIntent(Context context, @Nullable String string2, String string3) {
        Intent intent = new Intent("com.android.vending.billing.PURCHASE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setPackage("com.android.vending");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            intent.putExtra("authAccount", string2);
        }
        intent.putExtra("backend", 3);
        intent.putExtra("document_type", 1);
        intent.putExtra("full_docid", string3);
        intent.putExtra("backend_docid", string3);
        intent.putExtra("offer_type", 1);
        if (!GmsIntents.isIntentResolvable(context.getPackageManager(), intent)) {
            intent = new Intent("android.intent.action.VIEW");
            String string4 = String.format(Locale.US, "https://play.google.com/store/apps/details?id=%1$s&rdid=%1$s&rdot=%2$d", string3, 1);
            intent.setData(Uri.parse((String)string4));
            intent.setPackage("com.android.vending");
            intent.putExtra("use_direct_purchase", true);
        }
        return intent;
    }

    public static Intent createPlayStoreGamesIntent(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW");
        Uri uri = Uri.parse((String)"http://play.google.com/store/apps/category/GAME");
        intent.setData(uri);
        intent.addFlags(524288);
        intent.setPackage("com.android.vending");
        Intent intent2 = intent;
        if (context.getPackageManager().resolveActivity(intent2, 65536) == null) {
            Intent intent3 = new Intent(intent2.getAction(), intent2.getData());
            intent3.setFlags(intent2.getFlags());
            return intent3;
        }
        return intent2;
    }

    public static Intent createAndroidWearUpdateIntent() {
        Intent intent = new Intent("com.google.android.clockwork.home.UPDATE_ANDROID_WEAR_ACTION");
        intent.setPackage("com.google.android.wearable.app");
        return intent;
    }

    public static void sendUdcSettingsChangedBroadcast(Context context, String string2, int[] nArray) {
        GmsIntents.zza("com.google.android.gms", context, string2, nArray);
        if (!GoogleSignatureVerifier.getInstance(context).isPackageGoogleSigned(GOOGLE_NOW_PACKAGE_NAME)) {
            if (Log.isLoggable((String)"GmsIntents", (int)5)) {
                Log.w((String)"GmsIntents", (String)"Google now certificate not valid. UDC settings broadcast will not be sent.");
            }
            return;
        }
        GmsIntents.zza(GOOGLE_NOW_PACKAGE_NAME, context, string2, nArray);
    }

    private static void zza(String string2, Context context, String string3, int[] nArray) {
        Intent intent = new Intent(ACTION_UDC_SETTING_CHANGED).setPackage(string2).putExtra(EXTRA_UDC_ACCOUNT_NAME, string3).putExtra(EXTRA_UDC_SETTING_ID_LIST, nArray);
        if (Log.isLoggable((String)"GmsIntents", (int)3)) {
            String string4 = intent.getAction();
            Log.d((String)"GmsIntents", (String)new StringBuilder(72 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("UDC settings changed, sending broadcast to package ").append(string2).append(" with intent action: ").append(string4).toString());
        }
        context.sendBroadcast(intent);
    }

    public static void sendIcingContactChangedBroadcast(Context context, boolean bl) {
        Intent intent = new Intent(ACTION_ICING_CONTACT_CHANGED).setPackage("com.google.android.gms").putExtra(EXTRA_ICING_CONTACT_CHANGED_IS_SIGNIFICANT, bl);
        if (Log.isLoggable((String)"GmsIntents", (int)2)) {
            String string2 = intent.getAction();
            Log.v((String)"GmsIntents", (String)new StringBuilder(98 + String.valueOf(string2).length()).append("Icing detected contact change, broadcasting it with intent action: ").append(string2).append(" and isSignificant extra: ").append(bl).toString());
        }
        context.sendBroadcast(intent);
    }

    public static Intent createFindPeopleIntent(Context context) {
        return GmsIntents.zza(context, zzua);
    }

    public static Intent createShowProfileIntent(Context context, String string2) {
        String string3 = String.format("https://plus.google.com/%s/about", string2);
        return GmsIntents.zza(context, Uri.parse((String)string3));
    }

    private static Intent zza(Context context, Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        intent.setPackage("com.google.android.apps.plus");
        if (GmsIntents.isIntentResolvable(context.getPackageManager(), intent)) {
            return intent;
        }
        return GmsIntents.createPlayStoreIntent("com.google.android.apps.plus");
    }

    public static Intent createShareOnPlusIntent(Activity activity, String string2, String string3) {
        Intent intent = ShareCompat.IntentBuilder.from((Activity)activity).setSubject(string2).setText((CharSequence)string3).setType("text/plain").getIntent();
        intent.setPackage("com.google.android.apps.plus");
        if (GmsIntents.isIntentResolvable(activity.getPackageManager(), intent)) {
            return intent;
        }
        return GmsIntents.createPlayStoreIntent("com.google.android.apps.plus");
    }

    public static Intent createChooseGmsAccountIntent() {
        return AccountPicker.newChooseAccountIntent(null, null, new String[]{"com.google"}, true, null, null, null, null, true);
    }

    public static Intent createChooseGmsAccountWithConsentIntent(String string2, Scope[] scopeArray, boolean bl) {
        Intent intent = new Intent("com.google.android.gms.signin.action.SIGN_IN");
        intent.putExtra(COMMON_SIGN_IN_EXTRA_PACKAGE_NAME, string2);
        intent.putExtra(COMMON_SIGN_IN_EXTRA_SCOPE_ARRAY, (Parcelable[])scopeArray);
        intent.putExtra(COMMON_SIGN_IN_EXTRA_SAVE_DEFAULT_ACCOUNT, bl);
        return intent;
    }

    public static void sendSetGmsAccountIntent(Context context, String string2, String string3) {
        Intent intent = new Intent(ACTION_SET_GMS_ACCOUNT);
        intent.putExtra(EXTRA_SET_GMS_ACCOUNT_NAME, string2);
        intent.putExtra(EXTRA_SET_GMS_ACCOUNT_PACKAGE_NAME, string3);
        intent.setPackage("com.google.android.gms");
        context.sendBroadcast(intent, PERMISSION_GMS_INTERNAL_BROADCAST);
    }

    public static boolean isIntentResolvable(PackageManager packageManager, Intent intent) {
        return packageManager.resolveActivity(intent, 65536) != null;
    }

    public static Intent getFitnessAppDisconnectedIntent(String string2, String string3) {
        Intent intent = new Intent();
        intent.setPackage("com.google.android.gms");
        intent.setAction(ACTION_FITNESS_APP_DISCONNECTED);
        intent.setType(MIME_ACTIVITY_DISCONNECT_TYPE);
        intent.putExtra(EXTRA_APP, string2);
        intent.putExtra(EXTRA_ACCOUNT, string3);
        return intent;
    }
}

