/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.VisibleForTesting;

public abstract class GmsClientSupervisor {
    public static final int DEFAULT_BIND_FLAGS = 129;
    private static final Object zztm = new Object();
    private static GmsClientSupervisor zztn;

    public GmsClientSupervisor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GmsClientSupervisor getInstance(Context context) {
        Object object = zztm;
        synchronized (object) {
            if (zztn == null) {
                zztn = new zzh(context.getApplicationContext());
            }
        }
        return zztn;
    }

    public boolean bindService(String string2, ServiceConnection serviceConnection, String string3) {
        return this.bindService(new ConnectionStatusConfig(string2, 129), serviceConnection, string3);
    }

    public boolean bindService(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        return this.bindService(string2, string3, 129, serviceConnection, string4);
    }

    public boolean bindService(String string2, String string3, int n, ServiceConnection serviceConnection, String string4) {
        return this.bindService(new ConnectionStatusConfig(string2, string3, n), serviceConnection, string4);
    }

    public boolean bindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.bindService(new ConnectionStatusConfig(componentName, 129), serviceConnection, string2);
    }

    public void unbindService(String string2, ServiceConnection serviceConnection, String string3) {
        this.unbindService(new ConnectionStatusConfig(string2, 129), serviceConnection, string3);
    }

    public void unbindService(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        this.unbindService(string2, string3, 129, serviceConnection, string4);
    }

    public void unbindService(String string2, String string3, int n, ServiceConnection serviceConnection, String string4) {
        this.unbindService(new ConnectionStatusConfig(string2, string3, n), serviceConnection, string4);
    }

    public void unbindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.unbindService(new ConnectionStatusConfig(componentName, 129), serviceConnection, string2);
    }

    @VisibleForTesting
    public abstract void resetForTesting();

    protected abstract boolean bindService(ConnectionStatusConfig var1, ServiceConnection var2, String var3);

    protected abstract void unbindService(ConnectionStatusConfig var1, ServiceConnection var2, String var3);

    protected static final class ConnectionStatusConfig {
        private final String zzto;
        private final String zztp;
        private final ComponentName mComponentName;
        private final int zztq;

        public ConnectionStatusConfig(String string2, int n) {
            this.zzto = Preconditions.checkNotEmpty(string2);
            this.zztp = "com.google.android.gms";
            this.mComponentName = null;
            this.zztq = n;
        }

        public ConnectionStatusConfig(String string2, String string3, int n) {
            this.zzto = Preconditions.checkNotEmpty(string2);
            this.zztp = Preconditions.checkNotEmpty(string3);
            this.mComponentName = null;
            this.zztq = n;
        }

        public ConnectionStatusConfig(ComponentName componentName, int n) {
            this.zzto = null;
            this.zztp = null;
            this.mComponentName = Preconditions.checkNotNull(componentName);
            this.zztq = n;
        }

        public final String toString() {
            if (this.zzto == null) {
                return this.mComponentName.flattenToString();
            }
            return this.zzto;
        }

        public final String getAction() {
            return this.zzto;
        }

        public final String getPackage() {
            return this.zztp;
        }

        public final ComponentName getComponentName() {
            return this.mComponentName;
        }

        public final int getBindFlags() {
            return this.zztq;
        }

        public final Intent getStartServiceIntent(Context context) {
            Intent intent = this.zzto != null ? new Intent(this.zzto).setPackage(this.zztp) : new Intent().setComponent(this.mComponentName);
            return intent;
        }

        public final int hashCode() {
            return Objects.hashCode(this.zzto, this.zztp, this.mComponentName, this.zztq);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ConnectionStatusConfig)) {
                return false;
            }
            ConnectionStatusConfig connectionStatusConfig = (ConnectionStatusConfig)object;
            return Objects.equal(this.zzto, connectionStatusConfig.zzto) && Objects.equal(this.zztp, connectionStatusConfig.zztp) && Objects.equal(this.mComponentName, connectionStatusConfig.mComponentName) && this.zztq == connectionStatusConfig.zztq;
        }
    }
}

