/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import java.lang.reflect.Field;

public abstract class DowngradeableSafeParcel
extends AbstractSafeParcelable
implements ReflectedParcelable {
    private static final Object zzsj = new Object();
    private static ClassLoader zzsk = null;
    private static Integer zzsl = null;
    private boolean zzsm = false;

    public DowngradeableSafeParcel() {
    }

    static <T extends Parcelable> T getParcelable(Intent intent, String string2, Context context, Integer n) {
        Parcelable parcelable = null;
        try {
            if (context != null) {
                DowngradeableSafeParcel.zza(context.getClassLoader(), n);
                parcelable = intent.getParcelableExtra(string2);
            }
        }
        finally {
            DowngradeableSafeParcel.zza(null, null);
        }
        return (T)parcelable;
    }

    static Bundle getExtras(Intent intent, Context context, Integer n) {
        Bundle bundle = null;
        try {
            if (context != null) {
                DowngradeableSafeParcel.zza(context.getClassLoader(), n);
                if (intent.getExtras() != null) {
                    bundle = new Bundle();
                    bundle.putAll(intent.getExtras());
                }
            }
        }
        finally {
            DowngradeableSafeParcel.zza(null, null);
        }
        return bundle;
    }

    static <T extends Parcelable> T getParcelable(Bundle bundle, String string2, Context context, Integer n) {
        Parcelable parcelable = null;
        try {
            if (context != null) {
                DowngradeableSafeParcel.zza(context.getClassLoader(), n);
                parcelable = bundle.getParcelable(string2);
            }
        }
        finally {
            DowngradeableSafeParcel.zza(null, null);
        }
        return (T)parcelable;
    }

    static boolean putParcelable(Bundle bundle, String string2, DowngradeableSafeParcel downgradeableSafeParcel, Context context, Integer n) {
        if (context == null && n == null) {
            return false;
        }
        boolean bl = false;
        if (downgradeableSafeParcel.zza(context, n)) {
            bundle.putParcelable(string2, (Parcelable)downgradeableSafeParcel);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zza(ClassLoader classLoader, Integer n) {
        Object object = zzsj;
        synchronized (object) {
            zzsk = classLoader;
            zzsl = n;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClassLoader getUnparcelClassLoader() {
        Object object = zzsj;
        synchronized (object) {
            return zzsk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer getUnparcelClientVersion() {
        Object object = zzsj;
        synchronized (object) {
            return zzsl;
        }
    }

    protected abstract boolean prepareForClientVersion(int var1);

    private final boolean zza(Context context, Integer n) {
        if (n != null) {
            return this.prepareForClientVersion(n);
        }
        try {
            Class<?> clazz = context.getClassLoader().loadClass(this.getClass().getCanonicalName());
            this.setShouldDowngrade(!DowngradeableSafeParcel.zza(clazz));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean shouldDowngrade() {
        return this.zzsm;
    }

    public void setShouldDowngrade(boolean bl) {
        this.zzsm = bl;
    }

    protected static boolean canUnparcelSafely(String string2) {
        ClassLoader classLoader = DowngradeableSafeParcel.getUnparcelClassLoader();
        if (classLoader == null) {
            return true;
        }
        try {
            return DowngradeableSafeParcel.zza(classLoader.loadClass(string2));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean zza(Class<?> clazz) {
        try {
            Field field = clazz.getField("NULL");
            return "SAFE_PARCELABLE_NULL_STRING".equals(field.get(null));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    public static final class DowngradeableSafeParcelHelper {
        public DowngradeableSafeParcelHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T extends Parcelable> T getParcelable(Intent intent, String string2, Context context, Integer n) {
            Object object = zzsj;
            synchronized (object) {
                return DowngradeableSafeParcel.getParcelable(intent, string2, context, n);
            }
        }

        public static boolean putParcelable(Bundle bundle, String string2, DowngradeableSafeParcel downgradeableSafeParcel, Context context, Integer n) {
            return DowngradeableSafeParcel.putParcelable(bundle, string2, downgradeableSafeParcel, context, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Bundle getExtras(Intent intent, Context context, Integer n) {
            Object object = zzsj;
            synchronized (object) {
                return DowngradeableSafeParcel.getExtras(intent, context, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T extends Parcelable> T getParcelable(Bundle bundle, String string2, Context context, Integer n) {
            Object object = zzsj;
            synchronized (object) {
                return DowngradeableSafeParcel.getParcelable(bundle, string2, context, n);
            }
        }
    }
}

