/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.config;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Process;
import android.os.StrictMode;
import android.os.UserManager;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.config.zze;
import com.google.android.gms.common.config.zzf;
import com.google.android.gms.common.config.zzg;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.stable.zzi;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public abstract class GservicesValue<T> {
    private static final Object sLock = new Object();
    private static zza zzmu = null;
    private static int zzmv = 0;
    private static Context zzmw;
    private static String zzmx;
    @GuardedBy(value="sLock")
    private static HashSet<String> zzmy;
    protected final String mKey;
    protected final T mDefaultValue;
    private T zzmz = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=24)
    private static void zza(@Nullable Context context, zza zza2, @Nullable HashSet<String> hashSet) {
        Object object = sLock;
        synchronized (object) {
            zzmu = zza2;
            zzmy = null;
            zzmw = null;
            if (context != null && GservicesValue.zzd(context)) {
                zzmy = hashSet;
                zzmw = context.getApplicationContext().createDeviceProtectedStorageContext();
            }
            return;
        }
    }

    @Deprecated
    public static void init(Context context) {
        GservicesValue.init(context, GservicesValue.zzd(context) ? new HashSet() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, @Nullable HashSet<String> hashSet) {
        Object object = sLock;
        synchronized (object) {
            if (zzmu == null) {
                GservicesValue.zza(context, new zzd(context.getContentResolver()), hashSet);
            }
            if (zzmv == 0) {
                try {
                    zzmv = context.getPackageManager().getApplicationInfo((String)"com.google.android.gms", (int)0).uid;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e((String)"GservicesValue", (String)nameNotFoundException.toString());
                }
            }
            return;
        }
    }

    @TargetApi(value=24)
    public static SharedPreferences getDirectBootCache(Context context) {
        return context.getApplicationContext().createDeviceProtectedStorageContext().getSharedPreferences("gservices-direboot-cache", 0);
    }

    public static int getSharedUserId() {
        return zzmv;
    }

    @Deprecated
    @VisibleForTesting
    public static void initForTests() {
        GservicesValue.zza(null, new zzb(null), new HashSet<String>());
    }

    @VisibleForTesting
    public static void initForTests(Context context, @Nullable HashSet<String> hashSet) {
        GservicesValue.zza(context, new zzb(null), hashSet);
    }

    @Deprecated
    @VisibleForTesting
    public static void forceInit(Context context) {
        GservicesValue.forceInit(context, new HashSet<String>());
    }

    @VisibleForTesting
    public static void forceInit(Context context, @Nullable HashSet<String> hashSet) {
        GservicesValue.zza(context, new zzd(context.getContentResolver()), hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = sLock;
        synchronized (object) {
            return zzmu != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    public static void initForTests(Map<String, ?> map) {
        Object object = sLock;
        synchronized (object) {
            zzmu = new zzc(map);
            return;
        }
    }

    @Deprecated
    @VisibleForTesting
    public static void initForTests(String string2, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        hashMap.put(string2, object);
        GservicesValue.initForTests(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zzcg() {
        Object object = sLock;
        synchronized (object) {
            return zzmu instanceof zzb || zzmu instanceof zzc;
        }
    }

    protected GservicesValue(String string2, T t) {
        this.mKey = string2;
        this.mDefaultValue = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void override(T t) {
        if (!(zzmu instanceof zzb)) {
            Log.w((String)"GservicesValue", (String)"GservicesValue.override(): test should probably call initForTests() first");
        }
        this.zzmz = t;
        Object object = sLock;
        synchronized (object) {
            if (GservicesValue.zzcg()) {
                zzb.zzna.add(this);
            }
            return;
        }
    }

    @VisibleForTesting
    public void resetOverride() {
        this.zzmz = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void resetAllOverrides() {
        Object object = sLock;
        synchronized (object) {
            if (GservicesValue.zzcg()) {
                Iterator iterator = zzb.zzna.iterator();
                while (iterator.hasNext()) {
                    ((GservicesValue)iterator.next()).resetOverride();
                }
                zzb.zzna.clear();
            }
            return;
        }
    }

    protected abstract T retrieve(String var1);

    @TargetApi(value=24)
    protected T retrieveFromDirectBootCache(Context context, String string2, T t) {
        throw new UnsupportedOperationException("The Gservices classes used does not support direct-boot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() {
        Context context;
        HashSet<String> hashSet;
        boolean bl;
        if (this.zzmz != null) {
            return this.zzmz;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        Object object = sLock;
        synchronized (object) {
            bl = zzmw != null && GservicesValue.zzd(zzmw);
            hashSet = zzmy;
            context = zzmw;
        }
        if (bl) {
            if (Log.isLoggable((String)"GservicesValue", (int)3)) {
                String string2 = String.valueOf(this.mKey);
                Log.d((String)"GservicesValue", (String)(string2.length() != 0 ? "Gservice value accessed during directboot: ".concat(string2) : new String("Gservice value accessed during directboot: ")));
            }
            if (hashSet != null && !hashSet.contains(this.mKey)) {
                String string3 = String.valueOf(this.mKey);
                Log.e((String)"GservicesValue", (String)(string3.length() != 0 ? "Gservices key not whitelisted for directboot access: ".concat(string3) : new String("Gservices key not whitelisted for directboot access: ")));
                return this.mDefaultValue;
            }
            return this.retrieveFromDirectBootCache(context, this.mKey, this.mDefaultValue);
        }
        object = sLock;
        synchronized (object) {
            zzmy = null;
            zzmw = null;
        }
        try {
            object = this.retrieve(this.mKey);
            return (T)object;
        }
        catch (SecurityException securityException) {
            long l = Binder.clearCallingIdentity();
            T t = this.retrieve(this.mKey);
            return t;
            finally {
                Binder.restoreCallingIdentity((long)l);
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    @Deprecated
    public final T getBinderSafe() {
        return this.get();
    }

    public String getKey() {
        return this.mKey;
    }

    @TargetApi(value=24)
    private static boolean zzd(Context context) {
        if (!PlatformVersion.isAtLeastN()) {
            return false;
        }
        UserManager userManager = (UserManager)context.getSystemService(UserManager.class);
        if (userManager.isUserUnlocked()) {
            return false;
        }
        return !userManager.isUserRunning(Process.myUserHandle());
    }

    public static GservicesValue<Boolean> value(String string2, boolean bl) {
        return new com.google.android.gms.common.config.zza(string2, bl);
    }

    public static GservicesValue<Long> value(String string2, Long l) {
        return new com.google.android.gms.common.config.zzb(string2, l);
    }

    public static GservicesValue<Integer> value(String string2, Integer n) {
        return new com.google.android.gms.common.config.zzc(string2, n);
    }

    public static GservicesValue<Double> value(String string2, Double d) {
        return new com.google.android.gms.common.config.zzd(string2, d);
    }

    public static GservicesValue<Float> value(String string2, Float f) {
        return new zze(string2, f);
    }

    public static GservicesValue<String> value(String string2, String string3) {
        return new zzf(string2, string3);
    }

    public static GservicesValue<String> partnerSetting(String string2, String string3) {
        return new zzg(string2, string3);
    }

    static /* synthetic */ zza zzch() {
        return zzmu;
    }

    static {
        zzmx = "com.google.android.providers.gsf.permission.READ_GSERVICES";
    }

    @Deprecated
    private static final class zzc
    implements zza {
        private final Map<String, ?> values;

        public zzc(Map<String, ?> map) {
            this.values = map;
        }

        @Override
        public final Boolean zza(String string2, Boolean bl) {
            return this.zza(string2, (Object)bl);
        }

        @Override
        public final Integer zza(String string2, Integer n) {
            return this.zza(string2, (Object)n);
        }

        @Override
        public final Double zza(String string2, Double d) {
            return this.zza(string2, (Object)d);
        }

        @Override
        public final Float zza(String string2, Float f) {
            return this.zza(string2, (Object)f);
        }

        @Override
        public final Long getLong(String string2, Long l) {
            return this.zza(string2, l);
        }

        @Override
        public final String getString(String string2, String string3) {
            return this.zza(string2, string3);
        }

        @Override
        public final String zzb(String string2, String string3) {
            return this.zza(string2, string3);
        }

        private final <T> T zza(String string2, T t) {
            if (this.values.containsKey(string2)) {
                return (T)this.values.get(string2);
            }
            return t;
        }
    }

    private static final class zzb
    implements zza {
        private static final Collection<GservicesValue<?>> zzna = new HashSet();

        private zzb() {
        }

        @Override
        public final Boolean zza(String string2, Boolean bl) {
            return bl;
        }

        @Override
        public final Integer zza(String string2, Integer n) {
            return n;
        }

        @Override
        public final Double zza(String string2, Double d) {
            return d;
        }

        @Override
        public final Float zza(String string2, Float f) {
            return f;
        }

        @Override
        public final Long getLong(String string2, Long l) {
            return l;
        }

        @Override
        public final String getString(String string2, String string3) {
            return string3;
        }

        @Override
        public final String zzb(String string2, String string3) {
            return string3;
        }

        /* synthetic */ zzb(com.google.android.gms.common.config.zza zza2) {
            this();
        }
    }

    private static final class zzd
    implements zza {
        private final ContentResolver mContentResolver;

        public zzd(ContentResolver contentResolver) {
            this.mContentResolver = contentResolver;
        }

        @Override
        public final Boolean zza(String string2, Boolean bl) {
            return zzi.zza(this.mContentResolver, string2, bl);
        }

        @Override
        public final Integer zza(String string2, Integer n) {
            return zzi.getInt(this.mContentResolver, string2, n);
        }

        @Override
        public final Double zza(String string2, Double d) {
            String string3 = zzi.zza(this.mContentResolver, string2, null);
            if (string3 != null) {
                try {
                    return Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return d;
        }

        @Override
        public final Float zza(String string2, Float f) {
            String string3 = zzi.zza(this.mContentResolver, string2, null);
            if (string3 != null) {
                try {
                    return Float.valueOf(Float.parseFloat(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return f;
        }

        @Override
        public final Long getLong(String string2, Long l) {
            return zzi.getLong(this.mContentResolver, string2, l);
        }

        @Override
        public final String getString(String string2, String string3) {
            return zzi.zza(this.mContentResolver, string2, string3);
        }

        @Override
        public final String zzb(String string2, String string3) {
            return com.google.android.gms.internal.stable.zzg.zza(this.mContentResolver, string2, string3);
        }
    }

    private static interface zza {
        public Boolean zza(String var1, Boolean var2);

        public Long getLong(String var1, Long var2);

        public Integer zza(String var1, Integer var2);

        public Double zza(String var1, Double var2);

        public Float zza(String var1, Float var2);

        public String getString(String var1, String var2);

        public String zzb(String var1, String var2);
    }
}

