/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.content.Context;
import android.os.IBinder;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;

public abstract class RemoteCreator<T> {
    private final String zzabo;
    private T zzabp;

    protected RemoteCreator(String string2) {
        this.zzabo = string2;
    }

    protected final T getRemoteCreatorInstance(Context context) throws RemoteCreatorException {
        if (this.zzabp == null) {
            Preconditions.checkNotNull(context);
            Context context2 = GooglePlayServicesUtilLight.getRemoteContext(context);
            if (context2 == null) {
                throw new RemoteCreatorException("Could not get remote context.");
            }
            ClassLoader classLoader = context2.getClassLoader();
            try {
                IBinder iBinder = (IBinder)classLoader.loadClass(this.zzabo).newInstance();
                this.zzabp = this.getRemoteCreator(iBinder);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RemoteCreatorException("Could not load creator class.", classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new RemoteCreatorException("Could not instantiate creator.", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RemoteCreatorException("Could not access creator.", illegalAccessException);
            }
        }
        return this.zzabp;
    }

    protected abstract T getRemoteCreator(IBinder var1);

    public static class RemoteCreatorException
    extends Exception {
        public RemoteCreatorException(String string2) {
            super(string2);
        }

        public RemoteCreatorException(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }
}

