/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.os.Binder;
import android.os.Process;
import android.os.StrictMode;
import com.google.android.gms.common.util.IOUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.annotation.Nullable;

public class ProcessUtils {
    private static String zzaai = null;
    private static int zzaaj = 0;

    private ProcessUtils() {
    }

    @Nullable
    public static String getCallingProcessName() {
        int n = Binder.getCallingPid();
        if (n == ProcessUtils.zzde()) {
            return ProcessUtils.getMyProcessName();
        }
        return ProcessUtils.zzl(n);
    }

    @Nullable
    public static String getMyProcessName() {
        if (zzaai == null) {
            zzaai = ProcessUtils.zzl(ProcessUtils.zzde());
        }
        return zzaai;
    }

    public static boolean hasSystemGroups() throws SystemGroupsNotAvailableException {
        boolean iOException;
        BufferedReader bufferedReader = null;
        try {
            int bl = ProcessUtils.zzde();
            bufferedReader = ProcessUtils.zzm(new StringBuilder(24).append("/proc/").append(bl).append("/status").toString());
            iOException = ProcessUtils.zzk(bufferedReader);
        }
        catch (IOException iOException2) {
            try {
                throw new SystemGroupsNotAvailableException("Unable to access /proc/pid/status.", iOException2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bufferedReader);
        return iOException;
    }

    private static boolean zzk(BufferedReader bufferedReader) throws IOException, SystemGroupsNotAvailableException {
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if ((string2 = string2.trim()).startsWith("Groups:")) {
                for (String string3 : string2.substring(7).trim().split("\\s", -1)) {
                    try {
                        long l = Long.parseLong(string3);
                        if (l < 1000L || l >= 2000L) continue;
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return false;
            }
            string2 = bufferedReader.readLine();
        }
        throw new SystemGroupsNotAvailableException("Missing Groups entry from proc/pid/status.");
    }

    @Nullable
    private static String zzl(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            bufferedReader = ProcessUtils.zzm(new StringBuilder(25).append("/proc/").append(n).append("/cmdline").toString());
            string2 = bufferedReader.readLine().trim();
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(bufferedReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedReader);
        return string2;
    }

    private static BufferedReader zzm(String string2) throws IOException {
        BufferedReader bufferedReader;
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        return bufferedReader;
    }

    private static int zzde() {
        if (zzaaj == 0) {
            zzaaj = Process.myPid();
        }
        return zzaaj;
    }

    public static class SystemGroupsNotAvailableException
    extends Exception {
        SystemGroupsNotAvailableException(String string2) {
            super(string2);
        }

        SystemGroupsNotAvailableException(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }
}

