/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.net;

import android.content.Context;
import android.util.Log;
import com.google.android.gms.common.net.SocketFactoryCreator;
import com.google.android.gms.common.net.zza;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivateKey;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLCertificateSocketFactory
extends SSLSocketFactory {
    private static final TrustManager[] zzvf = new TrustManager[]{new zza()};
    @VisibleForTesting
    private SSLSocketFactory zzvg = null;
    @VisibleForTesting
    private SSLSocketFactory zzvh = null;
    @VisibleForTesting
    private TrustManager[] zzvi = null;
    @VisibleForTesting
    private KeyManager[] zzvj = null;
    @VisibleForTesting
    private byte[] zzvk = null;
    @VisibleForTesting
    private byte[] zzvl = null;
    @VisibleForTesting
    private PrivateKey zzvm = null;
    @VisibleForTesting
    private final Context mContext;
    @VisibleForTesting
    private final int zzvn;
    @VisibleForTesting
    private final boolean zzvo;
    @VisibleForTesting
    private final boolean zzvp;
    @VisibleForTesting
    private final String zzvq;

    private SSLCertificateSocketFactory(Context context, int n, boolean bl, boolean bl2, String string2) {
        this.mContext = context.getApplicationContext();
        this.zzvn = n;
        this.zzvo = bl;
        this.zzvp = bl2;
        this.zzvq = string2;
    }

    public static SocketFactory getDefault(Context context, int n) {
        return new SSLCertificateSocketFactory(context, n, false, true, null);
    }

    public static SSLSocketFactory getDefaultWithSessionCache(int n, Context context) {
        return new SSLCertificateSocketFactory(context, n, true, true, null);
    }

    public static SSLSocketFactory getDefaultWithCacheDir(int n, Context context, String string2) {
        return new SSLCertificateSocketFactory(context, n, true, true, string2);
    }

    public static SSLSocketFactory getInsecure(Context context, int n, boolean bl) {
        return new SSLCertificateSocketFactory(context, n, bl, false, null);
    }

    public static void verifyHostname(Socket socket, String string2) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Attempt to verify non-SSL socket");
        }
        SSLSocket sSLSocket = (SSLSocket)socket;
        sSLSocket.startHandshake();
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession == null) {
            throw new SSLException("Cannot verify SSL socket without session");
        }
        if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(string2, sSLSession)) {
            String string3 = String.valueOf(string2);
            throw new SSLPeerUnverifiedException(string3.length() != 0 ? "Cannot verify hostname: ".concat(string3) : new String("Cannot verify hostname: "));
        }
    }

    @VisibleForTesting
    private final synchronized SSLSocketFactory zzcx() {
        if (!this.zzvp) {
            if (this.zzvg == null) {
                Log.w((String)"SSLCertificateSocketFactory", (String)"Bypassing SSL security checks at caller's request");
                this.zzvg = SocketFactoryCreator.getInstance().makeSocketFactory(this.mContext, this.zzvj, zzvf, this.zzvo);
            }
            return this.zzvg;
        }
        if (this.zzvq != null) {
            if (this.zzvh == null) {
                this.zzvh = SocketFactoryCreator.getInstance().makeSocketFactoryWithCacheDir(this.mContext, this.zzvj, this.zzvi, this.zzvq);
            }
        } else if (this.zzvh == null) {
            this.zzvh = SocketFactoryCreator.getInstance().makeSocketFactory(this.mContext, this.zzvj, this.zzvi, this.zzvo);
        }
        return this.zzvh;
    }

    public void setTrustManagers(TrustManager[] trustManagerArray) {
        this.zzvi = trustManagerArray;
        this.zzvh = null;
    }

    public void setNpnProtocols(byte[][] byArray) {
        this.zzvk = SSLCertificateSocketFactory.zza(byArray);
    }

    public void setAlpnProtocols(byte[][] byArray) {
        this.zzvl = SSLCertificateSocketFactory.zza(byArray);
    }

    private static byte[] zza(byte[] ... byArray) {
        if (byArray.length == 0) {
            throw new IllegalArgumentException("items.length == 0");
        }
        int n = 0;
        Object object = byArray;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = object[i];
            if (byArray2.length == 0 || byArray2.length > 255) {
                int n3 = byArray2.length;
                throw new IllegalArgumentException(new StringBuilder(44).append("s.length == 0 || s.length > 255: ").append(n3).toString());
            }
            n += 1 + byArray2.length;
        }
        object = new byte[n];
        n2 = 0;
        byte[][] byArray3 = byArray;
        int n4 = byArray.length;
        for (int i = 0; i < n4; ++i) {
            byte[] byArray4 = byArray3[i];
            object[n2++] = (byte[])((byte)byArray4.length);
            byte[] byArray5 = byArray4;
            int n5 = byArray4.length;
            for (int j = 0; j < n5; ++j) {
                byte by = byArray5[j];
                object[n2++] = (byte[])by;
            }
        }
        return object;
    }

    public byte[] getNpnSelectedProtocol(Socket socket) {
        try {
            return (byte[])socket.getClass().getMethod("getNpnSelectedProtocol", new Class[0]).invoke((Object)socket, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(43 + String.valueOf(string2).length()).append("Failed to invoke getNpnSelectedProtocol on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(42 + String.valueOf(string3).length()).append(string3).append(" does not implement getNpnSelectedProtocol").toString(), reflectiveOperationException);
        }
    }

    public byte[] getAlpnSelectedProtocol(Socket socket) {
        try {
            return (byte[])socket.getClass().getMethod("getAlpnSelectedProtocol", new Class[0]).invoke((Object)socket, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(44 + String.valueOf(string2).length()).append("Failed to invoke getAlpnSelectedProtocol on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(43 + String.valueOf(string3).length()).append(string3).append(" does not implement getAlpnSelectedProtocol").toString(), reflectiveOperationException);
        }
    }

    public void setKeyManagers(KeyManager[] keyManagerArray) {
        this.zzvj = keyManagerArray;
        this.zzvh = null;
        this.zzvg = null;
    }

    public void setChannelIdPrivateKey(PrivateKey privateKey) {
        this.zzvm = privateKey;
    }

    public void setUseSessionTickets(Socket socket, boolean bl) {
        try {
            socket.getClass().getMethod("setUseSessionTickets", Boolean.TYPE).invoke((Object)socket, bl);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(41 + String.valueOf(string2).length()).append("Failed to invoke setUseSessionTickets on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(string3).length()).append(string3).append(" does not implement setUseSessionTickets").toString(), reflectiveOperationException);
        }
    }

    public void setHostname(Socket socket, String string2) {
        try {
            socket.getClass().getMethod("setHostname", String.class).invoke((Object)socket, string2);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string3 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(32 + String.valueOf(string3).length()).append("Failed to invoke setHostname on ").append(string3).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string4 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(31 + String.valueOf(string4).length()).append(string4).append(" does not implement setHostname").toString(), reflectiveOperationException);
        }
    }

    public void setSoWriteTimeout(Socket socket, int n) throws SocketException {
        try {
            socket.getClass().getMethod("setSoWriteTimeout", Integer.TYPE).invoke((Object)socket, n);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SocketException) {
                throw (SocketException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(38 + String.valueOf(string2).length()).append("Failed to invoke setSoWriteTimeout on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(37 + String.valueOf(string3).length()).append(string3).append(" does not implement setSoWriteTimeout").toString(), reflectiveOperationException);
        }
    }

    @Override
    public Socket createSocket(Socket socket, String string2, int n, boolean bl) throws IOException {
        Socket socket2 = this.zzcx().createSocket(socket, string2, n, bl);
        SSLCertificateSocketFactory.zza(socket2, this.zzvk);
        SSLCertificateSocketFactory.zzb(socket2, this.zzvl);
        SSLCertificateSocketFactory.zza(socket2, this.zzvn);
        SSLCertificateSocketFactory.zza(socket2, this.zzvm);
        if (this.zzvp) {
            SSLCertificateSocketFactory.verifyHostname(socket2, string2);
        }
        return socket2;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.zzcx().createSocket();
        SSLCertificateSocketFactory.zza(socket, this.zzvk);
        SSLCertificateSocketFactory.zzb(socket, this.zzvl);
        SSLCertificateSocketFactory.zza(socket, this.zzvn);
        SSLCertificateSocketFactory.zza(socket, this.zzvm);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.zzcx().createSocket(inetAddress, n, inetAddress2, n2);
        SSLCertificateSocketFactory.zza(socket, this.zzvk);
        SSLCertificateSocketFactory.zzb(socket, this.zzvl);
        SSLCertificateSocketFactory.zza(socket, this.zzvn);
        SSLCertificateSocketFactory.zza(socket, this.zzvm);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.zzcx().createSocket(inetAddress, n);
        SSLCertificateSocketFactory.zza(socket, this.zzvk);
        SSLCertificateSocketFactory.zzb(socket, this.zzvl);
        SSLCertificateSocketFactory.zza(socket, this.zzvn);
        SSLCertificateSocketFactory.zza(socket, this.zzvm);
        return socket;
    }

    @Override
    public Socket createSocket(String string2, int n, InetAddress inetAddress, int n2) throws IOException {
        Socket socket = this.zzcx().createSocket(string2, n, inetAddress, n2);
        SSLCertificateSocketFactory.zza(socket, this.zzvk);
        SSLCertificateSocketFactory.zzb(socket, this.zzvl);
        SSLCertificateSocketFactory.zza(socket, this.zzvn);
        SSLCertificateSocketFactory.zza(socket, this.zzvm);
        if (this.zzvp) {
            SSLCertificateSocketFactory.verifyHostname(socket, string2);
        }
        return socket;
    }

    @Override
    public Socket createSocket(String string2, int n) throws IOException {
        Socket socket = this.zzcx().createSocket(string2, n);
        SSLCertificateSocketFactory.zza(socket, this.zzvk);
        SSLCertificateSocketFactory.zzb(socket, this.zzvl);
        SSLCertificateSocketFactory.zza(socket, this.zzvn);
        SSLCertificateSocketFactory.zza(socket, this.zzvm);
        if (this.zzvp) {
            SSLCertificateSocketFactory.verifyHostname(socket, string2);
        }
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.zzcx().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.zzcx().getSupportedCipherSuites();
    }

    @VisibleForTesting
    private static void zza(Socket socket, byte[] byArray) {
        try {
            if (socket != null) {
                socket.getClass().getMethod("setNpnProtocols", byte[].class).invoke((Object)socket, new Object[]{byArray});
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to invoke setNpnProtocols on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(string3).length()).append(string3).append(" does not implement setNpnProtocols").toString(), reflectiveOperationException);
        }
    }

    @VisibleForTesting
    private static void zzb(Socket socket, byte[] byArray) {
        try {
            if (socket != null) {
                socket.getClass().getMethod("setAlpnProtocols", byte[].class).invoke((Object)socket, new Object[]{byArray});
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(37 + String.valueOf(string2).length()).append("Failed to invoke setAlpnProtocols on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string3).length()).append(string3).append(" does not implement setAlpnProtocols").toString(), reflectiveOperationException);
        }
    }

    @VisibleForTesting
    private static void zza(Socket socket, int n) {
        try {
            if (socket != null) {
                socket.getClass().getMethod("setHandshakeTimeout", Integer.TYPE).invoke((Object)socket, n);
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(46 + String.valueOf(string2).length()).append("Failed to invoke setSocketHandshakeTimeout on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string3).length()).append(string3).append(" does not implement setSocketHandshakeTimeout").toString(), reflectiveOperationException);
        }
    }

    @VisibleForTesting
    private static void zza(Socket socket, PrivateKey privateKey) {
        try {
            if (socket != null) {
                socket.getClass().getMethod("setChannelIdPrivateKey", PrivateKey.class).invoke((Object)socket, privateKey);
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String string2 = String.valueOf(socket.getClass());
            throw new RuntimeException(new StringBuilder(43 + String.valueOf(string2).length()).append("Failed to invoke setChannelIdPrivateKey on ").append(string2).toString(), invocationTargetException2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            String string3 = String.valueOf(socket.getClass());
            throw new IllegalArgumentException(new StringBuilder(42 + String.valueOf(string3).length()).append(string3).append(" does not implement setChannelIdPrivateKey").toString(), reflectiveOperationException);
        }
    }
}

