/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.logging;

import android.annotation.SuppressLint;
import android.util.Log;
import com.google.android.gms.common.internal.GmsLogger;
import java.util.Locale;

public class Logger {
    private final String mTag;
    private final String zzud;
    private final GmsLogger zzvd;
    private final int zzve;

    public Logger(String string2, String ... stringArray) {
        String string3;
        String[] stringArray2 = stringArray;
        if (stringArray.length == 0) {
            string3 = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            String[] stringArray3 = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray3[i];
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string4);
            }
            stringBuilder.append(']').append(' ');
            string3 = stringBuilder.toString();
        }
        this(string2, string3);
    }

    private Logger(String string2, String string3) {
        int n;
        this.zzud = string3;
        this.mTag = string2;
        this.zzvd = new GmsLogger(string2);
        Logger logger = this;
        for (n = 2; 7 >= n && !Log.isLoggable((String)logger.mTag, (int)n); ++n) {
        }
        this.zzve = n;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isLoggable(int n) {
        return this.zzve <= n;
    }

    public boolean isPiiLoggable() {
        return this.zzvd.canLogPii();
    }

    public String elidePii(Object object) {
        Object object2 = object;
        boolean bl = this.zzvd.canLogPii();
        if (object2 == null) {
            return "<NULL>";
        }
        String string2 = object2.toString().trim();
        if (string2.isEmpty()) {
            return "<EMPTY>";
        }
        if (bl) {
            return string2;
        }
        return String.format("<ELLIDED:%s>", string2.hashCode());
    }

    public void v(String string2, Object ... objectArray) {
        if (this.isLoggable(2)) {
            Log.v((String)this.mTag, (String)this.format(string2, objectArray));
        }
    }

    public void v(String string2, Throwable throwable, Object ... objectArray) {
        if (this.isLoggable(2)) {
            Log.v((String)this.mTag, (String)this.format(string2, objectArray), (Throwable)throwable);
        }
    }

    public void d(String string2, Object ... objectArray) {
        if (this.isLoggable(3)) {
            Log.d((String)this.mTag, (String)this.format(string2, objectArray));
        }
    }

    public void d(String string2, Throwable throwable, Object ... objectArray) {
        if (this.isLoggable(3)) {
            Log.d((String)this.mTag, (String)this.format(string2, objectArray), (Throwable)throwable);
        }
    }

    public void i(String string2, Object ... objectArray) {
        Log.i((String)this.mTag, (String)this.format(string2, objectArray));
    }

    public void i(String string2, Throwable throwable, Object ... objectArray) {
        Log.i((String)this.mTag, (String)this.format(string2, objectArray), (Throwable)throwable);
    }

    public void w(String string2, Object ... objectArray) {
        Log.w((String)this.mTag, (String)this.format(string2, objectArray));
    }

    public void w(String string2, Throwable throwable, Object ... objectArray) {
        Log.w((String)this.mTag, (String)this.format(string2, objectArray), (Throwable)throwable);
    }

    public void w(Throwable throwable) {
        Log.w((String)this.mTag, (Throwable)throwable);
    }

    public void e(String string2, Object ... objectArray) {
        Log.e((String)this.mTag, (String)this.format(string2, objectArray));
    }

    public void e(String string2, Throwable throwable, Object ... objectArray) {
        Log.e((String)this.mTag, (String)this.format(string2, objectArray), (Throwable)throwable);
    }

    @SuppressLint(value={"WtfWithoutException"})
    public void wtf(String string2, Object ... objectArray) {
        Log.wtf((String)this.mTag, (String)this.format(string2, objectArray));
    }

    public void wtf(String string2, Throwable throwable, Object ... objectArray) {
        Log.wtf((String)this.mTag, (String)this.format(string2, objectArray), (Throwable)throwable);
    }

    public void wtf(Throwable throwable) {
        Log.wtf((String)this.mTag, (Throwable)throwable);
    }

    protected String format(String string2, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            string2 = String.format(Locale.US, string2, objectArray);
        }
        return this.zzud.concat(string2);
    }
}

