/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.IAccountAccessor;

public class AccountAccessor
extends IAccountAccessor.Stub {
    private Account zzs;
    private Context mContext;
    private int zzqu = -1;

    public static AccountAccessor fromGoogleAccountName(Context context, String string2) {
        Account account = TextUtils.isEmpty((CharSequence)string2) ? null : new Account(string2, "com.google");
        return new AccountAccessor(context, account);
    }

    public static Account getAccountBinderSafe(IAccountAccessor iAccountAccessor) {
        Account account = null;
        if (iAccountAccessor != null) {
            long l = Binder.clearCallingIdentity();
            try {
                account = iAccountAccessor.getAccount();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"AccountAccessor", (String)"Remote account accessor probably died");
            }
            finally {
                Binder.restoreCallingIdentity((long)l);
            }
        }
        return account;
    }

    public AccountAccessor(Context context, Account account) {
        this.mContext = context.getApplicationContext();
        this.zzs = account;
    }

    @Override
    public Account getAccount() {
        int n = Binder.getCallingUid();
        if (n == this.zzqu) {
            return this.zzs;
        }
        if (GooglePlayServicesUtilLight.isGooglePlayServicesUid(this.mContext, n)) {
            this.zzqu = n;
            return this.zzs;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccountAccessor)) {
            return false;
        }
        return this.zzs.equals((Object)((AccountAccessor)object).zzs);
    }
}

