/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public final class BackgroundDetector
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2 {
    private static final BackgroundDetector zzem = new BackgroundDetector();
    private final AtomicBoolean zzen = new AtomicBoolean();
    private final AtomicBoolean zzeo = new AtomicBoolean();
    @GuardedBy(value="sInstance")
    private final ArrayList<BackgroundStateChangeListener> zzep = new ArrayList();
    @GuardedBy(value="sInstance")
    private boolean zzeq = false;

    @KeepForSdk
    private BackgroundDetector() {
    }

    @KeepForSdk
    public static BackgroundDetector getInstance() {
        return zzem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void initialize(Application application) {
        BackgroundDetector backgroundDetector = zzem;
        synchronized (backgroundDetector) {
            if (!BackgroundDetector.zzem.zzeq) {
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzem);
                application.registerComponentCallbacks((ComponentCallbacks)zzem);
                BackgroundDetector.zzem.zzeq = true;
            }
            return;
        }
    }

    @TargetApi(value=16)
    @KeepForSdk
    public final boolean readCurrentStateIfPossible(boolean bl) {
        if (!this.zzeo.get()) {
            if (PlatformVersion.isAtLeastJellyBean()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
                ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)runningAppProcessInfo);
                if (!this.zzeo.getAndSet(true) && runningAppProcessInfo.importance > 100) {
                    this.zzen.set(true);
                }
            } else {
                return bl;
            }
        }
        return this.isInBackground();
    }

    @KeepForSdk
    public final boolean isInBackground() {
        return this.zzen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void addListener(BackgroundStateChangeListener backgroundStateChangeListener) {
        BackgroundDetector backgroundDetector = zzem;
        synchronized (backgroundDetector) {
            this.zzep.add(backgroundStateChangeListener);
            return;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        boolean bl = this.zzen.compareAndSet(true, false);
        this.zzeo.set(true);
        if (bl) {
            this.onBackgroundStateChanged(false);
        }
    }

    public final void onActivityResumed(Activity activity) {
        boolean bl = this.zzen.compareAndSet(true, false);
        this.zzeo.set(true);
        if (bl) {
            this.onBackgroundStateChanged(false);
        }
    }

    public final void onTrimMemory(int n) {
        if (n == 20 && this.zzen.compareAndSet(false, true)) {
            this.zzeo.set(true);
            this.onBackgroundStateChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onBackgroundStateChanged(boolean bl) {
        BackgroundDetector backgroundDetector = zzem;
        synchronized (backgroundDetector) {
            ArrayList<BackgroundStateChangeListener> arrayList = this.zzep;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                BackgroundStateChangeListener backgroundStateChangeListener = arrayList.get(i);
                backgroundStateChangeListener.onBackgroundStateChanged(bl);
            }
            return;
        }
    }

    public final void onActivityStarted(Activity activity) {
    }

    public final void onActivityPaused(Activity activity) {
    }

    public final void onActivityStopped(Activity activity) {
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public final void onActivityDestroyed(Activity activity) {
    }

    public final void onConfigurationChanged(Configuration configuration) {
    }

    public final void onLowMemory() {
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        @KeepForSdk
        public void onBackgroundStateChanged(boolean var1);
    }
}

