/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleCertificates;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.ICertData;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.common.zzb;
import com.google.android.gms.common.zzd;
import com.google.android.gms.common.zzg;
import com.google.android.gms.dynamic.ObjectWrapper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckReturnValue;

@CheckReturnValue
public class GoogleSignatureVerifier {
    private static GoogleSignatureVerifier zzbv;
    private final Context mContext;

    private GoogleSignatureVerifier(Context context) {
        this.mContext = context.getApplicationContext();
    }

    @VisibleForTesting
    public static synchronized void resetForTests() {
        zzbv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleSignatureVerifier getInstance(Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (GoogleSignatureVerifier.class) {
            if (zzbv == null) {
                GoogleCertificates.init(context);
                zzbv = new GoogleSignatureVerifier(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbv;
        }
    }

    @Deprecated
    public void verifyUidIsGoogleSigned(PackageManager packageManager, int n) throws SecurityException {
        this.verifyUidIsGoogleSigned(n);
    }

    public void verifyUidIsGoogleSigned(int n) throws SecurityException {
        this.zzb(n).zzh();
    }

    @Deprecated
    public boolean isUidGoogleSigned(PackageManager packageManager, int n) {
        return this.isUidGoogleSigned(n);
    }

    public boolean isUidGoogleSigned(int n) {
        zzg zzg2 = this.zzb(n);
        zzg2.zzi();
        return zzg2.zzbl;
    }

    @Deprecated
    public void verifyPackageIsGoogleSigned(PackageManager packageManager, String string2) throws SecurityException {
        this.verifyPackageIsGoogleSigned(string2);
    }

    public void verifyPackageIsGoogleSigned(String string2) throws SecurityException {
        this.zzf(string2).zzh();
    }

    @Deprecated
    public boolean isPackageGoogleSigned(PackageManager packageManager, String string2) {
        return this.isPackageGoogleSigned(string2);
    }

    public boolean isPackageGoogleSigned(String string2) {
        zzg zzg2 = this.zzf(string2);
        zzg2.zzi();
        return zzg2.zzbl;
    }

    @Deprecated
    public boolean isPackageGoogleSigned(PackageManager packageManager, PackageInfo packageInfo) {
        return this.isPackageGoogleSigned(packageInfo);
    }

    public boolean isPackageGoogleSigned(PackageInfo packageInfo) {
        zzg zzg2 = this.zza(packageInfo);
        zzg2.zzi();
        return zzg2.zzbl;
    }

    @Deprecated
    public Set<byte[]> getAllGoogleSignatures(boolean bl) {
        Set<ICertData> set = bl ? GoogleCertificates.zzd() : GoogleCertificates.zze();
        HashSet<byte[]> hashSet = new HashSet<byte[]>(set.size());
        try {
            Iterator<ICertData> iterator = set.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])ObjectWrapper.unwrap(iterator.next().getBytesWrapped());
                hashSet.add(byArray);
            }
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GoogleSignatureVerifier", (String)"Failed to get Google certificates from remote", (Throwable)remoteException);
        }
        return hashSet;
    }

    public boolean isGooglePublicSignedPackage(PackageInfo packageInfo, boolean bl) {
        return packageInfo != null && packageInfo.signatures != null && (bl ? GoogleSignatureVerifier.zza(packageInfo, zzd.zzbg) : GoogleSignatureVerifier.zza(packageInfo, zzd.zzbg[0])) != null;
    }

    @Deprecated
    public boolean isGooglePublicSignedPackage(PackageManager packageManager, PackageInfo packageInfo) {
        return this.isGooglePublicSignedPackage(packageInfo);
    }

    public boolean isGooglePublicSignedPackage(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (this.isGooglePublicSignedPackage(packageInfo, false)) {
            return true;
        }
        if (this.isGooglePublicSignedPackage(packageInfo, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    public boolean isChimeraSigned(PackageManager packageManager, PackageInfo packageInfo) {
        String string2 = packageInfo.packageName;
        packageInfo.packageName = "com.google.android.gms.chimera";
        boolean bl = this.isPackageGoogleSigned(packageInfo);
        packageInfo.packageName = string2;
        return bl;
    }

    private final zzg zzb(int n) {
        String[] stringArray = Wrappers.packageManager(this.mContext).getPackagesForUid(n);
        if (stringArray == null || stringArray.length == 0) {
            return zzg.zze("no pkgs");
        }
        zzg zzg2 = null;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray2[i];
            zzg2 = this.zzf(string2);
            if (!zzg2.zzbl) continue;
            return zzg2;
        }
        return zzg2;
    }

    private final zzg zzf(String string2) {
        PackageInfo packageInfo;
        try {
            packageInfo = Wrappers.packageManager(this.mContext).getPackageInfo(string2, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            return zzg.zze(string3.length() != 0 ? "no pkg ".concat(string3) : new String("no pkg "));
        }
        return this.zza(packageInfo);
    }

    private final zzg zza(PackageInfo packageInfo) {
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext);
        PackageInfo packageInfo2 = packageInfo;
        if (packageInfo2 == null) {
            return zzg.zze("null pkg");
        }
        if (packageInfo2.signatures.length != 1) {
            return zzg.zze("single cert required");
        }
        zzb zzb2 = new zzb(packageInfo2.signatures[0].toByteArray());
        String string2 = packageInfo2.packageName;
        zzg zzg2 = GoogleCertificates.zza(string2, zzb2, bl);
        if (zzg2.zzbl && packageInfo2.applicationInfo != null && (packageInfo2.applicationInfo.flags & 2) != 0 && (!bl || GoogleCertificates.zza((String)string2, (GoogleCertificates.CertData)zzb2, (boolean)false).zzbl)) {
            return zzg.zze("debuggable release cert app rejected");
        }
        return zzg2;
    }

    private static GoogleCertificates.CertData zza(PackageInfo packageInfo, GoogleCertificates.CertData ... certDataArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzb zzb2 = new zzb(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < certDataArray.length; ++i) {
            if (!certDataArray[i].equals(zzb2)) continue;
            return certDataArray[i];
        }
        return null;
    }
}

