/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleCertificates;
import com.google.android.gms.common.GoogleCertificatesQueryCreator;
import com.google.android.gms.common.internal.ICertData;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zzb;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import javax.annotation.Nullable;

@SafeParcelable.Class(creator="GoogleCertificatesQueryCreator")
public class GoogleCertificatesQuery
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GoogleCertificatesQuery> CREATOR = new GoogleCertificatesQueryCreator();
    @SafeParcelable.Field(id=1, getter="getCallingPackage")
    private final String zzbh;
    @Nullable
    @SafeParcelable.Field(id=2, type="android.os.IBinder", getter="getCallingCertificateBinder")
    private final GoogleCertificates.CertData zzbi;
    @SafeParcelable.Field(id=3, getter="getAllowTestKeys")
    private final boolean zzbj;

    @SafeParcelable.Constructor
    GoogleCertificatesQuery(@SafeParcelable.Param(id=1) String string2, @Nullable @SafeParcelable.Param(id=2) IBinder iBinder, @SafeParcelable.Param(id=3) boolean bl) {
        this.zzbh = string2;
        this.zzbi = GoogleCertificatesQuery.zza(iBinder);
        this.zzbj = bl;
    }

    GoogleCertificatesQuery(String string2, @Nullable GoogleCertificates.CertData certData, boolean bl) {
        this.zzbh = string2;
        this.zzbi = certData;
        this.zzbj = bl;
    }

    public String getCallingPackage() {
        return this.zzbh;
    }

    @Nullable
    public GoogleCertificates.CertData getCertificate() {
        return this.zzbi;
    }

    @Nullable
    public IBinder getCallingCertificateBinder() {
        if (this.zzbi == null) {
            Log.w((String)"GoogleCertificatesQuery", (String)"certificate binder is null");
            return null;
        }
        return this.zzbi.asBinder();
    }

    public boolean getAllowTestKeys() {
        return this.zzbj;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleCertificatesQuery googleCertificatesQuery = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeString(parcel2, 1, googleCertificatesQuery.getCallingPackage(), false);
        SafeParcelWriter.writeIBinder(parcel2, 2, googleCertificatesQuery.getCallingCertificateBinder(), false);
        SafeParcelWriter.writeBoolean(parcel2, 3, googleCertificatesQuery.getAllowTestKeys());
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    @Nullable
    private static GoogleCertificates.CertData zza(@Nullable IBinder iBinder) {
        IObjectWrapper iObjectWrapper;
        if (iBinder == null) {
            return null;
        }
        zzb zzb2 = null;
        try {
            iObjectWrapper = ICertData.Stub.asInterface(iBinder).getBytesWrapped();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GoogleCertificatesQuery", (String)"Could not unwrap certificate", (Throwable)remoteException);
            return null;
        }
        byte[] byArray = iObjectWrapper == null ? null : (byte[])ObjectWrapper.unwrap(iObjectWrapper);
        if (byArray != null) {
            zzb2 = new zzb(byArray);
        } else {
            Log.e((String)"GoogleCertificatesQuery", (String)"Could not unwrap certificate");
        }
        return zzb2;
    }
}

