/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.accounts.Account;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;

public final class AccountPicker {
    public static final String EXTRA_ALLOWABLE_ACCOUNTS_ARRAYLIST = "allowableAccounts";
    public static final String EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY = "allowableAccountTypes";
    public static final String EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE = "addAccountOptions";
    public static final String EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY = "addAccountRequiredFeatures";
    public static final String EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING = "authTokenType";
    public static final String EXTRA_SELECTED_ACCOUNT = "selectedAccount";
    public static final String EXTRA_ALWAYS_PROMPT_FOR_ACCOUNT = "alwaysPromptForAccount";
    public static final String EXTRA_DESCRIPTION_TEXT_OVERRIDE = "descriptionTextOverride";
    public static final String EXTRA_SET_GMS_CORE_ACCOUNT = "setGmsCoreAccount";
    public static final String EXTRA_OVERRIDE_THEME = "overrideTheme";
    public static final String EXTRA_REAL_CLIENT_PACKAGE = "realClientPackage";
    public static final int THEME_DEFAULT = 0;
    public static final int THEME_LIGHT = 1;
    public static final String EXTRA_OVERRIDE_CUSTOM_THEME = "overrideCustomTheme";
    public static final String EXTRA_HOSTED_DOMAIN_FILTER = "hostedDomainFilter";
    public static final int CUSTOM_THEME_NONE = 0;
    public static final int CUSTOM_THEME_GAMES = 1;
    public static final int CUSTOM_THEME_ACCOUNT_CHIPS = 2;
    public static final String EXTRA_IS_ACCOUNT_CHIPS_ACCOUNT_PICKER = "pickedFromAccountChips";

    private AccountPicker() {
    }

    public static Intent newChooseAccountIntent(Account account, ArrayList<Account> arrayList, String[] stringArray, boolean bl, String string, String string2, String[] stringArray2, Bundle bundle) {
        return AccountPicker.newChooseAccountIntent(account, arrayList, stringArray, bl, string, string2, stringArray2, bundle, false);
    }

    public static Intent newChooseAccountIntent(Account account, ArrayList<Account> arrayList, String[] stringArray, boolean bl, String string, String string2, String[] stringArray2, Bundle bundle, boolean bl2) {
        return AccountPicker.newChooseAccountIntent(account, arrayList, stringArray, bl, string, string2, stringArray2, bundle, bl2, 0, 0);
    }

    public static Intent newChooseAccountIntent(Account account, ArrayList<Account> arrayList, String[] stringArray, boolean bl, String string, String string2, String[] stringArray2, Bundle bundle, boolean bl2, int n, int n2) {
        return AccountPicker.newChooseAccountIntent(account, arrayList, stringArray, bl, string, string2, stringArray2, bundle, bl2, n, n2, null, false);
    }

    public static Intent newChooseAccountIntent(Account account, ArrayList<Account> arrayList, String[] stringArray, boolean bl, String string, String string2, String[] stringArray2, Bundle bundle, boolean bl2, int n, int n2, String string3, boolean bl3) {
        Intent intent = new Intent();
        if (!bl3) {
            Preconditions.checkArgument(string3 == null, "We only support hostedDomain filter for account chip styled account picker");
        }
        String string4 = bl3 ? "com.google.android.gms.common.account.CHOOSE_ACCOUNT_USERTILE" : "com.google.android.gms.common.account.CHOOSE_ACCOUNT";
        intent.setAction(string4);
        intent.setPackage("com.google.android.gms");
        intent.putExtra(EXTRA_ALLOWABLE_ACCOUNTS_ARRAYLIST, arrayList);
        intent.putExtra(EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY, stringArray);
        intent.putExtra(EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE, bundle);
        intent.putExtra(EXTRA_SELECTED_ACCOUNT, (Parcelable)account);
        intent.putExtra(EXTRA_ALWAYS_PROMPT_FOR_ACCOUNT, bl);
        intent.putExtra(EXTRA_DESCRIPTION_TEXT_OVERRIDE, string);
        intent.putExtra(EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING, string2);
        intent.putExtra(EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY, stringArray2);
        intent.putExtra(EXTRA_SET_GMS_CORE_ACCOUNT, bl2);
        intent.putExtra(EXTRA_OVERRIDE_THEME, n);
        intent.putExtra(EXTRA_OVERRIDE_CUSTOM_THEME, n2);
        intent.putExtra(EXTRA_HOSTED_DOMAIN_FILTER, string3);
        return intent;
    }
}

