/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzan;
import com.google.android.gms.common.internal.zzay;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzf;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzgen;
    private long zzgeo;
    private long zzgep;
    private int zzgeq;
    private long zzger;
    private zzam zzges;
    private final Context mContext;
    private final Looper zzalj;
    private final zzag zzget;
    private final zzf zzfwk;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzgeu = new Object();
    private zzay zzgev;
    protected zzj zzgew;
    private T zzgex;
    private final ArrayList<zzi<?>> zzgey = new ArrayList();
    private zzl zzgez;
    private int zzgfa = 1;
    private final com.google.android.gms.common.internal.zzf zzgfb;
    private final zzg zzgfc;
    private final int zzgfd;
    private final String zzgfe;
    private ConnectionResult zzgff = null;
    private boolean zzgfg = false;
    protected AtomicInteger zzgfh = new AtomicInteger(0);
    @Hide
    private static String[] zzgfi = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, com.google.android.gms.common.internal.zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzag.zzcp(context), zzf.zzahf(), n, zzbq.checkNotNull(zzf2), zzbq.checkNotNull(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzag zzag2, zzf zzf2, int n, com.google.android.gms.common.internal.zzf zzf3, zzg zzg2, String string2) {
        this.mContext = zzbq.checkNotNull(context, "Context must not be null");
        this.zzalj = zzbq.checkNotNull(looper, "Looper must not be null");
        this.zzget = zzbq.checkNotNull(zzag2, "Supervisor must not be null");
        this.zzfwk = zzbq.checkNotNull(zzf2, "API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzgfd = n;
        this.zzgfb = zzf3;
        this.zzgfc = zzg2;
        this.zzgfe = string2;
    }

    @Hide
    @NonNull
    protected abstract String zzhm();

    @Hide
    protected String zzalq() {
        return "com.google.android.gms";
    }

    @Hide
    @NonNull
    protected abstract String zzhn();

    @Hide
    @Nullable
    private final String zzalr() {
        if (this.zzgfe == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzgfe;
    }

    @Hide
    @Nullable
    protected abstract T zzd(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzgep = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzgen = n;
        this.zzgeo = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzgeq = connectionResult.getErrorCode();
        this.zzger = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbq.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzgfa = n;
            this.zzgex = t;
            this.zzb(n, t);
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzgez != null && zzd2.zzges != null) {
                        String string3 = zzd2.zzges.zzamx();
                        string2 = zzd2.zzges.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzget.zza(zzd2.zzges.zzamx(), zzd2.zzges.getPackageName(), zzd2.zzges.zzamu(), zzd2.zzgez, zzd2.zzalr());
                        zzd2.zzgfh.incrementAndGet();
                    }
                    zzd2.zzgez = new zzl(zzd2, zzd2.zzgfh.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzges = new zzam(zzd3.zzalq(), zzd3.zzhm(), false, 129);
                    String string4 = zzd2.zzalr();
                    zzl zzl2 = zzd2.zzgez;
                    int n2 = zzd2.zzges.zzamu();
                    String string5 = zzd2.zzges.getPackageName();
                    String string6 = zzd2.zzges.zzamx();
                    if (zzd2.zzget.zza(new zzah(string6, string5, n2), (ServiceConnection)zzl2, string4)) break;
                    string2 = zzd2.zzges.zzamx();
                    String string7 = zzd2.zzges.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzgfh.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzgez == null) break;
                    zzd4.zzget.zza(zzd4.zzhm(), zzd4.zzalq(), 129, zzd4.zzgez, zzd4.zzalr());
                    zzd4.zzgez = null;
                }
            }
            return;
        }
    }

    void zzb(int n, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzgfa != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzals() {
        int n = this.zzfwk.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzgew = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzgfa == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzgfa == 2 || this.zzgfa == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    private final boolean zzalt() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzgfa == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzgfh.incrementAndGet();
        Object object = this.zzgey;
        synchronized (object) {
            int n = this.zzgey.size();
            for (int i = 0; i < n; ++i) {
                this.zzgey.get(i).removeListener();
            }
            this.zzgey.clear();
        }
        object = this.zzgeu;
        synchronized (object) {
            this.zzgev = null;
        }
        this.zza(1, null);
    }

    @Hide
    public final void zzcd(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzgfh.get(), n));
    }

    @Hide
    private final void zzce(int n) {
        int n2;
        if (this.zzalt()) {
            n2 = 5;
            this.zzgfg = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzgfh.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzgew = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzgfh.get(), n, (Object)pendingIntent));
    }

    @Hide
    public final Context getContext() {
        return this.mContext;
    }

    @Hide
    public final Looper getLooper() {
        return this.zzalj;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzalu() {
        return new zzc[0];
    }

    @Hide
    protected Bundle zzabt() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    @Hide
    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    @Hide
    protected final void zzalv() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzagp() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final T zzalw() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzgfa == 5) {
                throw new DeadObjectException();
            }
            this.zzalv();
            zzbq.zza(this.zzgex != null, (Object)"Client is connected but service is null");
            return this.zzgex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @WorkerThread
    public final void zza(zzan zzan2, Set<Scope> set) {
        Bundle bundle = this.zzabt();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzz(this.zzgfd);
        new zzz(this.zzgfd).zzggd = object;
        object = bundle;
        v0.zzggg = object;
        zzz zzz2 = object2;
        if (set != null) {
            object = set;
            zzz2.zzggf = object.toArray(new Scope[object.size()]);
        }
        if (this.zzacc()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzz2;
            zzz2.zzggh = object;
            object = zzan2;
            if (object != null) {
                ((zzz)object2).zzgge = object.asBinder();
            }
        } else if (this.zzalx()) {
            zzz2.zzggh = object = this.getAccount();
        }
        object = this.zzalu();
        zzz2.zzggi = object;
        try {
            Object object3 = this.zzgeu;
            synchronized (object3) {
                if (this.zzgev != null) {
                    this.zzgev.zza(new zzk(this, this.zzgfh.get()), zzz2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzcd(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzgfh.get());
            return;
        }
    }

    public boolean zzacc() {
        return false;
    }

    public void zza(@NonNull zzp zzp2) {
        zzp2.zzako();
    }

    public boolean zzalx() {
        return false;
    }

    public boolean zzahn() {
        return true;
    }

    public boolean zzacn() {
        return false;
    }

    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzaly() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzay zzay2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzgfa;
            t = this.zzgex;
        }
        object = this.zzgeu;
        synchronized (object) {
            zzay2 = this.zzgev;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzhn()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzay2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzay2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzgep > 0L) {
            l = this.zzgep;
            string3 = ((DateFormat)object).format(new Date(this.zzgep));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzgeo > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzgen) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzgen));
                }
            }
            l = this.zzgeo;
            string3 = ((DateFormat)object).format(new Date(this.zzgeo));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzger > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzgeq));
            l = this.zzger;
            string3 = ((DateFormat)object).format(new Date(this.zzger));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IBinder zzaho() {
        Object object = this.zzgeu;
        synchronized (object) {
            if (this.zzgev == null) {
                return null;
            }
            return this.zzgev.asBinder();
        }
    }

    private final boolean zzalz() {
        if (this.zzgfg) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzhn())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzhn());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Hide
    public final String zzahp() {
        if (this.isConnected() && this.zzges != null) {
            return this.zzges.getPackageName();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzce(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzgeu;
    }

    static /* synthetic */ zzay zza(zzd zzd2, zzay zzay2) {
        zzd2.zzgev = zzay2;
        return zzd2.zzgev;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzgff = connectionResult;
        return zzd2.zzgff;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzalz();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzgfg;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzgff;
    }

    static /* synthetic */ com.google.android.gms.common.internal.zzf zze(zzd zzd2) {
        return zzd2.zzgfb;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzgey;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzgfc;
    }
}

