/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzch;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzcg
extends Fragment
implements zzcf {
    private static WeakHashMap<Activity, WeakReference<zzcg>> zzgan = new WeakHashMap();
    private Map<String, LifecycleCallback> zzgao = new ArrayMap();
    private int zzcfl = 0;
    private Bundle zzgap;

    public static zzcg zzp(Activity activity) {
        zzcg zzcg2;
        WeakReference<zzcg> weakReference = zzgan.get(activity);
        if (weakReference != null && (zzcg2 = (zzcg)weakReference.get()) != null) {
            return zzcg2;
        }
        try {
            zzcg2 = (zzcg)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzcg2 == null || zzcg2.isRemoving()) {
            zzcg2 = new zzcg();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzcg2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzgan.put(activity, new WeakReference<zzcg>(zzcg2));
        return zzcg2;
    }

    @Override
    public final <T extends LifecycleCallback> T zza(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzgao.get(string2)));
    }

    @Override
    public final void zza(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzgao.containsKey(string2)) {
            this.zzgao.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzcg zzcg2 = this;
            if (zzcg2.zzcfl > 0) {
                new Handler(Looper.getMainLooper()).post((Runnable)new zzch(zzcg2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final Activity zzakw() {
        return this.getActivity();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzcfl = 1;
        this.zzgap = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzgao.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzcfl = 2;
        Iterator<LifecycleCallback> iterator = this.zzgao.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzcfl = 3;
        Iterator<LifecycleCallback> iterator = this.zzgao.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzgao.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzgao.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzcfl = 4;
        Iterator<LifecycleCallback> iterator = this.zzgao.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzcfl = 5;
        Iterator<LifecycleCallback> iterator = this.zzgao.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzgao.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ int zza(zzcg zzcg2) {
        return zzcg2.zzcfl;
    }

    static /* synthetic */ Bundle zzb(zzcg zzcg2) {
        return zzcg2.zzgap;
    }
}

