/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.common.zzf;
import com.google.android.gms.common.zzt;
import com.google.android.gms.internal.zzbih;
import java.util.concurrent.atomic.AtomicBoolean;

@Hide
public class zzs {
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = 12210000;
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @Hide
    private static boolean zzb = false;
    @Hide
    private static boolean zzc = false;
    private static boolean zzd = false;
    private static boolean zze = false;
    static final AtomicBoolean zza = new AtomicBoolean();
    private static final AtomicBoolean zzf = new AtomicBoolean();

    zzs() {
    }

    @Deprecated
    public static String getErrorString(int n) {
        return ConnectionResult.zza(n);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        return zzs.zza(context, -1);
    }

    @Deprecated
    public static int zza(Context context, int n) {
        try {
            context.getResources().getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(context.getPackageName())) {
            Context context2 = context;
            if (!zzf.get()) {
                int n2 = zzbf.zzb(context2);
                if (n2 == 0) {
                    throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
                }
                if (n2 != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                    int n3 = GOOGLE_PLAY_SERVICES_VERSION_CODE;
                    throw new IllegalStateException(new StringBuilder(320).append("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected ").append(n3).append(" but found ").append(n2).append(".  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />").toString());
                }
            }
        }
        boolean bl = !zzj.zzb(context) && !zzj.zzd(context);
        return zzs.zza(context, bl, GOOGLE_PLAY_SERVICES_VERSION_CODE, n);
    }

    private static int zza(Context context, boolean bl, int n, int n2) {
        PackageInfo packageInfo;
        zzbq.zzb(n2 == -1 || n2 >= 0);
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo2 = null;
        if (bl) {
            try {
                packageInfo2 = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is missing.");
                return 9;
            }
        }
        try {
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        zzt.zza(context);
        if (!zzt.zza(packageInfo, true)) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
            return 9;
        }
        if (!(!bl || zzt.zza(packageInfo2, true) && packageInfo2.signatures[0].equals((Object)packageInfo.signatures[0]))) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
            return 9;
        }
        int n3 = packageInfo.versionCode / 1000;
        int n4 = n / 1000;
        if (n3 < n4 && (n2 == -1 || n3 < n2 / 1000)) {
            int n5 = GOOGLE_PLAY_SERVICES_VERSION_CODE;
            int n6 = packageInfo.versionCode;
            Log.w((String)"GooglePlayServicesUtil", (String)new StringBuilder(77).append("Google Play services out of date.  Requires ").append(n5).append(" but found ").append(n6).toString());
            return 2;
        }
        ApplicationInfo applicationInfo = packageInfo.applicationInfo;
        if (applicationInfo == null) {
            try {
                applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.", (Throwable)nameNotFoundException);
                return 1;
            }
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    @Hide
    public static void zza(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Context context2 = context;
        com.google.android.gms.common.zzf.zza();
        int n = com.google.android.gms.common.zzf.zza(context2, -1);
        if (n != 0) {
            com.google.android.gms.common.zzf.zza();
            Intent intent = com.google.android.gms.common.zzf.zza(context2, n, "e");
            Log.e((String)"GooglePlayServicesUtil", (String)new StringBuilder(57).append("GooglePlayServices not available due to error ").append(n).toString());
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            throw new GooglePlayServicesRepairableException(n, "Google Play Services not available", intent);
        }
    }

    @Deprecated
    @Hide
    public static boolean zzb(Context context, int n) {
        return zzz.zza(context, n);
    }

    @Deprecated
    @Hide
    @TargetApi(value=19)
    public static boolean zza(Context context, int n, String string2) {
        return zzz.zza(context, n, string2);
    }

    @Hide
    public static boolean zzb(Context context) {
        Context context2 = context;
        if (!zze) {
            Context context3 = context2;
            try {
                PackageInfo packageInfo = zzbih.zza(context3).zzb(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                zzt.zza(context3);
                zzd = packageInfo != null && !zzt.zza(packageInfo, false) && zzt.zza(packageInfo, true);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Cannot find Google Play services package name.", (Throwable)nameNotFoundException);
            }
            finally {
                zze = true;
            }
        }
        return zzd || !"user".equals(Build.TYPE);
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int n, Context context, int n2) {
        return com.google.android.gms.common.zzf.zza().getErrorResolutionPendingIntent(context, n, n2);
    }

    @Deprecated
    @Hide
    public static void zzc(Context context) {
        if (zza.getAndSet(true)) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager != null) {
                notificationManager.cancel(10436);
            }
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    @Deprecated
    public static boolean isUserRecoverableError(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    @Hide
    public static int zzd(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 0;
        }
        return packageInfo.versionCode;
    }

    @Deprecated
    @Hide
    public static boolean zzc(Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return zzs.zza(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=21)
    static boolean zza(Context context, String string2) {
        Object object;
        Object object2;
        boolean bl = string2.equals(GOOGLE_PLAY_SERVICES_PACKAGE);
        if (com.google.android.gms.common.util.zzs.zzg()) {
            try {
                object2 = context.getPackageManager().getPackageInstaller().getAllSessions();
            }
            catch (Exception exception) {
                return false;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                PackageInstaller.SessionInfo sessionInfo = (PackageInstaller.SessionInfo)object.next();
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        }
        object2 = context.getPackageManager();
        try {
            object = object2.getApplicationInfo(string2, 8192);
            if (bl) {
                return ((ApplicationInfo)object).enabled;
            }
            if (((ApplicationInfo)object).enabled) {
                Bundle bundle;
                Context context2 = context;
                if (!(com.google.android.gms.common.util.zzs.zzd() && (bundle = ((UserManager)context2.getSystemService("user")).getApplicationRestrictions(context2.getPackageName())) != null && "true".equals(bundle.getString("restricted_profile")))) {
                    return true;
                }
            }
            return false;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }
}

