/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzan;
import com.google.android.gms.common.internal.zzay;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzf;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzd;
    private long zze;
    private long zzf;
    private int zzg;
    private long zzh;
    private zzam zzi;
    private final Context zzj;
    private final Looper zzk;
    private final zzag zzl;
    private final zzf zzm;
    final Handler zza;
    private final Object zzn = new Object();
    private final Object zzo = new Object();
    private zzay zzp;
    protected zzj zzb;
    private T zzq;
    private final ArrayList<zzi<?>> zzr = new ArrayList();
    private zzl zzs;
    private int zzt = 1;
    private final com.google.android.gms.common.internal.zzf zzu;
    private final zzg zzv;
    private final int zzw;
    private final String zzx;
    private ConnectionResult zzy = null;
    private boolean zzz = false;
    protected AtomicInteger zzc = new AtomicInteger(0);
    @Hide
    private static String[] zzaa = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, com.google.android.gms.common.internal.zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzag.zza(context), com.google.android.gms.common.zzf.zza(), n, zzbq.zza(zzf2), zzbq.zza(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzag zzag2, zzf zzf2, int n, com.google.android.gms.common.internal.zzf zzf3, zzg zzg2, String string2) {
        this.zzj = zzbq.zza(context, (Object)"Context must not be null");
        this.zzk = zzbq.zza(looper, (Object)"Looper must not be null");
        this.zzl = zzbq.zza(zzag2, (Object)"Supervisor must not be null");
        this.zzm = zzbq.zza(zzf2, (Object)"API availability must not be null");
        this.zza = new zzh(this, looper);
        this.zzw = n;
        this.zzu = zzf3;
        this.zzv = zzg2;
        this.zzx = string2;
    }

    @Hide
    @NonNull
    protected abstract String zza();

    @Hide
    protected String zzy() {
        return "com.google.android.gms";
    }

    @Hide
    @NonNull
    protected abstract String zzb();

    @Hide
    @Nullable
    private final String zzi() {
        if (this.zzx == null) {
            return this.zzj.getClass().getName();
        }
        return this.zzx;
    }

    @Hide
    @Nullable
    protected abstract T zza(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzf = System.currentTimeMillis();
    }

    @CallSuper
    protected void zza(int n) {
        this.zzd = n;
        this.zze = System.currentTimeMillis();
    }

    @CallSuper
    protected void zza(ConnectionResult connectionResult) {
        this.zzg = connectionResult.getErrorCode();
        this.zzh = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzb(int n, T t) {
        zzbq.zzb(n == 4 == (t != null));
        Object object = this.zzn;
        synchronized (object) {
            this.zzt = n;
            this.zzq = t;
            this.zza(n, t);
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzs != null && zzd2.zzi != null) {
                        String string3 = zzd2.zzi.zza();
                        string2 = zzd2.zzi.zzb();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzl.zza(zzd2.zzi.zza(), zzd2.zzi.zzb(), zzd2.zzi.zzc(), zzd2.zzs, zzd2.zzi());
                        zzd2.zzc.incrementAndGet();
                    }
                    zzd2.zzs = new zzl(zzd2, zzd2.zzc.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzi = new zzam(zzd3.zzy(), zzd3.zza(), false, 129);
                    String string4 = zzd2.zzi();
                    zzl zzl2 = zzd2.zzs;
                    int n2 = zzd2.zzi.zzc();
                    String string5 = zzd2.zzi.zzb();
                    String string6 = zzd2.zzi.zza();
                    if (zzd2.zzl.zza(new zzah(string6, string5, n2), (ServiceConnection)zzl2, string4)) break;
                    string2 = zzd2.zzi.zza();
                    String string7 = zzd2.zzi.zzb();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzc.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzs == null) break;
                    zzd4.zzl.zza(zzd4.zza(), zzd4.zzy(), 129, zzd4.zzs, zzd4.zzi());
                    zzd4.zzs = null;
                }
            }
            return;
        }
    }

    void zza(int n, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.zzn;
        synchronized (object) {
            if (this.zzt != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public final void zzz() {
        int n = this.zzm.isGooglePlayServicesAvailable(this.zzj);
        if (n != 0) {
            this.zzb(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzb = zzbq.zza(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzs() {
        Object object = this.zzn;
        synchronized (object) {
            return this.zzt == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzt() {
        Object object = this.zzn;
        synchronized (object) {
            return this.zzt == 2 || this.zzt == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    private final boolean zzj() {
        Object object = this.zzn;
        synchronized (object) {
            return this.zzt == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg() {
        this.zzc.incrementAndGet();
        Object object = this.zzr;
        synchronized (object) {
            int n = this.zzr.size();
            for (int i = 0; i < n; ++i) {
                this.zzr.get(i).zze();
            }
            this.zzr.clear();
        }
        object = this.zzo;
        synchronized (object) {
            this.zzp = null;
        }
        this.zzb(1, null);
    }

    @Hide
    public final void zzb(int n) {
        this.zza.sendMessage(this.zza.obtainMessage(6, this.zzc.get(), n));
    }

    @Hide
    private final void zzc(int n) {
        int n2;
        if (this.zzj()) {
            n2 = 5;
            this.zzz = true;
        } else {
            n2 = 4;
        }
        this.zza.sendMessage(this.zza.obtainMessage(n2, this.zzc.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzb = zzbq.zza(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.zza.sendMessage(this.zza.obtainMessage(3, this.zzc.get(), n, (Object)pendingIntent));
    }

    @Hide
    public final Context zzaa() {
        return this.zzj;
    }

    @Hide
    public final Looper zzab() {
        return this.zzk;
    }

    public Account zzac() {
        return null;
    }

    public zzc[] zzad() {
        return new zzc[0];
    }

    @Hide
    protected Bundle zzc() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.zza.sendMessage(this.zza.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    @Hide
    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.zza.sendMessage(this.zza.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    @Hide
    protected final void zzae() {
        if (!this.zzs()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle q_() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final T zzaf() throws DeadObjectException {
        Object object = this.zzn;
        synchronized (object) {
            if (this.zzt == 5) {
                throw new DeadObjectException();
            }
            this.zzae();
            zzbq.zza(this.zzq != null, (Object)"Client is connected but service is null");
            return this.zzq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @WorkerThread
    public final void zza(zzan zzan2, Set<Scope> set) {
        Bundle bundle = this.zzc();
        Object object = this.zzj.getPackageName();
        Object object2 = new zzz(this.zzw);
        new zzz(this.zzw).zza = object;
        object = bundle;
        v0.zzd = object;
        zzz zzz2 = object2;
        if (set != null) {
            object = set;
            zzz2.zzc = object.toArray(new Scope[object.size()]);
        }
        if (this.l_()) {
            object2 = this;
            object = ((zzd)object2).zzac() != null ? ((zzd)object2).zzac() : new Account("<<default account>>", "com.google");
            object2 = zzz2;
            zzz2.zze = object;
            object = zzan2;
            if (object != null) {
                ((zzz)object2).zzb = object.asBinder();
            }
        } else if (this.zzag()) {
            zzz2.zze = object = this.zzac();
        }
        object = this.zzad();
        zzz2.zzf = object;
        try {
            Object object3 = this.zzo;
            synchronized (object3) {
                if (this.zzp != null) {
                    this.zzp.zza(new zzk(this, this.zzc.get()), zzz2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzb(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzc.get());
            return;
        }
    }

    public boolean l_() {
        return false;
    }

    public void zza(@NonNull zzp zzp2) {
        zzp2.zza();
    }

    public boolean zzag() {
        return false;
    }

    public boolean zzu() {
        return true;
    }

    public boolean zze() {
        return false;
    }

    public Intent zzf() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzah() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzay zzay2;
        T t;
        int n;
        Object object = this.zzn;
        synchronized (object) {
            n = this.zzt;
            t = this.zzq;
        }
        object = this.zzo;
        synchronized (object) {
            zzay2 = this.zzp;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzb()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzay2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzay2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzf > 0L) {
            l = this.zzf;
            string3 = ((DateFormat)object).format(new Date(this.zzf));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zze > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzd) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzd));
                }
            }
            l = this.zze;
            string3 = ((DateFormat)object).format(new Date(this.zze));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzh > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzg));
            l = this.zzh;
            string3 = ((DateFormat)object).format(new Date(this.zzh));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IBinder zzv() {
        Object object = this.zzo;
        synchronized (object) {
            if (this.zzp == null) {
                return null;
            }
            return this.zzp.asBinder();
        }
    }

    private final boolean zzk() {
        if (this.zzz) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzb())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzb());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Hide
    public final String zzw() {
        if (this.zzs() && this.zzi != null) {
            return this.zzi.zzb();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzc(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzo;
    }

    static /* synthetic */ zzay zza(zzd zzd2, zzay zzay2) {
        zzd2.zzp = zzay2;
        return zzd2.zzp;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzy = connectionResult;
        return zzd2.zzy;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzk();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzz;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zzb(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzy;
    }

    static /* synthetic */ com.google.android.gms.common.internal.zzf zze(zzd zzd2) {
        return zzd2.zzu;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzr;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzv;
    }
}

