/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class Status
extends zzbgl
implements Result,
ReflectedParcelable {
    @Hide
    public static final Status zza = new Status(0);
    @Hide
    public static final Status zzb = new Status(14);
    @Hide
    public static final Status zzc = new Status(8);
    @Hide
    public static final Status zzd = new Status(15);
    @Hide
    public static final Status zze = new Status(16);
    @Hide
    private static Status zzf = new Status(17);
    @Hide
    private static Status zzg = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzg();
    private int zzh;
    private final int zzi;
    @Nullable
    private final String zzj;
    @Nullable
    private final PendingIntent zzk;

    Status(int n, int n2, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this.zzh = n;
        this.zzi = n2;
        this.zzj = string2;
        this.zzk = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzk.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzj;
    }

    public final boolean hasResolution() {
        return this.zzk != null;
    }

    public final boolean isSuccess() {
        return this.zzi <= 0;
    }

    public final boolean isCanceled() {
        return this.zzi == 16;
    }

    public final boolean isInterrupted() {
        return this.zzi == 14;
    }

    public final int getStatusCode() {
        return this.zzi;
    }

    public final PendingIntent getResolution() {
        return this.zzk;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzh, this.zzi, this.zzj, this.zzk});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzh == status.zzh && this.zzi == status.zzi && zzbg.zza(this.zzj, status.zzj) && zzbg.zza(this.zzk, status.zzk);
    }

    @Hide
    public final String zza() {
        if (this.zzj != null) {
            return this.zzj;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzi);
    }

    public final String toString() {
        return zzbg.zza(this).zza("statusCode", this.zza()).zza("resolution", this.zzk).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = zzbgo.zza(parcel2);
        zzbgo.zza(parcel2, 1, status.getStatusCode());
        zzbgo.zza(parcel2, 2, status.getStatusMessage(), false);
        zzbgo.zza(parcel2, 3, (Parcelable)status.zzk, n, false);
        zzbgo.zza(parcel2, 1000, status.zzh);
        zzbgo.zza(parcel2, n2);
    }

    @Override
    public final Status getStatus() {
        return this;
    }
}

