/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.zzf;
import com.google.android.gms.common.zzp;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final zzf zzkbn = zzf.zzafy();
    private static final Object sLock = new Object();
    private static Method zzkbo = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    public ProviderInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        zzbq.checkNotNull(context, "Context must not be null");
        zzf.zzcd(context);
        Context context2 = zzp.getRemoteContext(context);
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = sLock;
        synchronized (object) {
            try {
                if (zzkbo == null) {
                    Class<?> clazz = context2.getClassLoader().loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
                    Class[] classArray = new Class[]{Context.class};
                    zzkbo = clazz.getMethod("insertProvider", classArray);
                }
                zzkbo.invoke(null, context2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to install provider: ".concat(string2) : new String("Failed to install provider: ")));
                throw new GooglePlayServicesNotAvailableException(8);
            }
            return;
        }
    }

    public static void installIfNeededAsync(Context context, ProviderInstallListener providerInstallListener) {
        zzbq.checkNotNull(context, "Context must not be null");
        zzbq.checkNotNull(providerInstallListener, "Listener must not be null");
        zzbq.zzge("Must be called on the UI thread");
        new zza(context, providerInstallListener).execute(new Void[0]);
    }

    static /* synthetic */ zzf zzbda() {
        return zzkbn;
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

