/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzam;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class zzal
implements zzb {
    private final Map<String, zzam> zzbx = new LinkedHashMap<String, zzam>(16, 0.75f, true);
    private long zzby = 0L;
    private final File zzbz;
    private final int zzca;

    private zzal(File file, int n) {
        this.zzbz = file;
        this.zzca = 0x500000;
    }

    public zzal(File file) {
        this(file, 0x500000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final synchronized zzc zza(String string2) {
        zzam zzam2 = this.zzbx.get(string2);
        if (zzam2 == null) {
            return null;
        }
        File file = this.zze(string2);
        try (zzan zzan2 = new zzan(new BufferedInputStream(zzal.zza(file)), file.length());){
            byte[] byArray;
            zzam zzam3 = zzam.zzc(zzan2);
            if (!TextUtils.equals((CharSequence)string2, (CharSequence)zzam3.key)) {
                zzae.zzb("%s: key=%s, found=%s", file.getAbsolutePath(), string2, zzam3.key);
                this.removeEntry(string2);
                return null;
            }
            byte[] byArray2 = byArray = zzal.zza(zzan2, zzan2.zzn());
            zzam zzam4 = zzam2;
            zzc zzc2 = new zzc();
            new zzc().data = byArray2;
            zzc2.zza = zzam4.zza;
            zzc2.zzb = zzam4.zzb;
            zzc2.zzc = zzam4.zzc;
            zzc2.zzd = zzam4.zzd;
            zzc2.zze = zzam4.zze;
            zzc2.zzf = zzao.zza(zzam4.zzg);
            zzc2.zzg = Collections.unmodifiableList(zzam4.zzg);
            zzc zzc3 = zzc2;
            return zzc3;
        }
        catch (IOException iOException) {
            zzae.zzb("%s: %s", file.getAbsolutePath(), iOException.toString());
            this.remove(string2);
            return null;
        }
    }

    @Override
    public final synchronized void initialize() {
        if (!this.zzbz.exists()) {
            if (!this.zzbz.mkdirs()) {
                zzae.zzc("Unable to create cache dir %s", this.zzbz.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.zzbz.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            try {
                long l = file.length();
                try (zzan zzan2 = new zzan(new BufferedInputStream(zzal.zza(file)), l);){
                    zzam zzam2 = zzam.zzc(zzan2);
                    zzam.zzc(zzan2).zzcb = l;
                    this.zza(zzam2.key, zzam2);
                    continue;
                }
            }
            catch (IOException iOException) {
                file.delete();
            }
        }
    }

    @Override
    public final synchronized void zza(String string2, zzc zzc2) {
        int n = zzc2.data.length;
        Object object = this;
        if (((zzal)object).zzby + (long)n >= (long)((zzal)object).zzca) {
            if (zzae.DEBUG) {
                zzae.zza("Pruning old cache entries.", new Object[0]);
            }
            long l = ((zzal)object).zzby;
            int n2 = 0;
            long l2 = SystemClock.elapsedRealtime();
            Iterator<Map.Entry<String, zzam>> iterator = ((zzal)object).zzbx.entrySet().iterator();
            while (iterator.hasNext()) {
                zzam zzam2 = iterator.next().getValue();
                if (super.zze(zzam2.key).delete()) {
                    ((zzal)object).zzby -= zzam2.zzcb;
                } else {
                    zzae.zzb("Could not delete cache entry for key=%s, filename=%s", zzam2.key, zzal.zzd(zzam2.key));
                }
                iterator.remove();
                ++n2;
                if (!((float)(((zzal)object).zzby + (long)n) < (float)((zzal)object).zzca * 0.9f)) continue;
            }
            if (zzae.DEBUG) {
                zzae.zza("pruned %d files, %d bytes, %d ms", n2, ((zzal)object).zzby - l, SystemClock.elapsedRealtime() - l2);
            }
        }
        File file = this.zze(string2);
        try {
            object = file;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            zzam zzam3 = new zzam(string2, zzc2);
            if (!zzam3.zza(bufferedOutputStream)) {
                bufferedOutputStream.close();
                zzae.zzb("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            bufferedOutputStream.write(zzc2.data);
            bufferedOutputStream.close();
            this.zza(string2, zzam3);
            return;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                zzae.zzb("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    private final synchronized void remove(String string2) {
        boolean bl = this.zze(string2).delete();
        this.removeEntry(string2);
        if (!bl) {
            zzae.zzb("Could not delete cache entry for key=%s, filename=%s", string2, zzal.zzd(string2));
        }
    }

    private static String zzd(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(String.valueOf(string2.substring(0, n).hashCode()));
        String string4 = String.valueOf(String.valueOf(string2.substring(n).hashCode()));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    private final File zze(String string2) {
        return new File(this.zzbz, zzal.zzd(string2));
    }

    private final void zza(String string2, zzam zzam2) {
        if (!this.zzbx.containsKey(string2)) {
            this.zzby += zzam2.zzcb;
        } else {
            zzam zzam3 = this.zzbx.get(string2);
            this.zzby += zzam2.zzcb - zzam3.zzcb;
        }
        this.zzbx.put(string2, zzam2);
    }

    private final void removeEntry(String string2) {
        zzam zzam2 = this.zzbx.remove(string2);
        if (zzam2 != null) {
            this.zzby -= zzam2.zzcb;
        }
    }

    private static byte[] zza(zzan zzan2, long l) throws IOException {
        long l2 = zzan2.zzn();
        if (l < 0L || l > l2 || (long)((int)l) != l) {
            throw new IOException(new StringBuilder(73).append("streamToBytes length=").append(l).append(", maxLength=").append(l2).toString());
        }
        byte[] byArray = new byte[(int)l];
        new DataInputStream(zzan2).readFully(byArray);
        return byArray;
    }

    private static InputStream zza(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
    }

    static int zzb(InputStream inputStream) throws IOException {
        return 0 | zzal.zza(inputStream) | zzal.zza(inputStream) << 8 | zzal.zza(inputStream) << 16 | zzal.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)l);
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        return 0L | (long)zzal.zza(inputStream) & 0xFFL | ((long)zzal.zza(inputStream) & 0xFFL) << 8 | ((long)zzal.zza(inputStream) & 0xFFL) << 16 | ((long)zzal.zza(inputStream) & 0xFFL) << 24 | ((long)zzal.zza(inputStream) & 0xFFL) << 32 | ((long)zzal.zza(inputStream) & 0xFFL) << 40 | ((long)zzal.zza(inputStream) & 0xFFL) << 48 | ((long)zzal.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzal.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zza(zzan zzan2) throws IOException {
        long l = zzal.zzc(zzan2);
        byte[] byArray = zzal.zza(zzan2, l);
        return new String(byArray, "UTF-8");
    }

    static List<zzl> zzb(zzan zzan2) throws IOException {
        int n = zzal.zzb((InputStream)zzan2);
        ArrayList<zzl> arrayList = n == 0 ? Collections.emptyList() : new ArrayList<zzl>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = zzal.zza(zzan2).intern();
            String string3 = zzal.zza(zzan2).intern();
            arrayList.add(new zzl(string2, string3));
        }
        return arrayList;
    }
}

