/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zza;
import com.google.android.gms.internal.zzaa;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzac;
import com.google.android.gms.internal.zzad;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.internal.zzah;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzg;
import com.google.android.gms.internal.zzl;
import com.google.android.gms.internal.zzm;
import com.google.android.gms.internal.zzo;
import com.google.android.gms.internal.zzp;
import com.google.android.gms.internal.zzq;
import com.google.android.gms.internal.zzr;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class zzai
implements zzm {
    private static boolean DEBUG = zzae.DEBUG;
    @Deprecated
    private zzaq zzbp;
    private final zzah zzbq;
    private zzaj zzbr;

    @Deprecated
    public zzai(zzaq zzaq2) {
        this(zzaq2, new zzaj(4096));
    }

    @Deprecated
    private zzai(zzaq zzaq2, zzaj zzaj2) {
        this.zzbp = zzaq2;
        this.zzbq = new zzag(zzaq2);
        this.zzbr = zzaj2;
    }

    public zzai(zzah zzah2) {
        this(zzah2, new zzaj(4096));
    }

    private zzai(zzah zzah2, zzaj zzaj2) {
        this.zzbq = zzah2;
        this.zzbp = zzah2;
        this.zzbr = zzaj2;
    }

    @Override
    public zzp zzc(zzr<?> zzr2) throws zzad {
        long l = SystemClock.elapsedRealtime();
        while (true) {
            Object object;
            int n;
            zzap zzap2 = null;
            byte[] byArray = null;
            List<zzl> list = Collections.emptyList();
            try {
                Object object2;
                Map<String, String> map;
                zzc zzc2 = zzr2.zze();
                if (zzc2 == null) {
                    map = Collections.emptyMap();
                } else {
                    object2 = new HashMap<String, String>();
                    if (zzc2.zza != null) {
                        object2.put("If-None-Match", zzc2.zza);
                    }
                    if (zzc2.zzc > 0L) {
                        object2.put((String)"If-Modified-Since", (String)zzao.zzb(zzc2.zzc));
                    }
                    map = object2;
                }
                Map<String, String> map2 = map;
                zzap2 = this.zzbq.zza(zzr2, map2);
                n = zzap2.getStatusCode();
                list = zzap2.zzp();
                if (n == 304) {
                    object = zzr2.zze();
                    if (object == null) {
                        return new zzp(304, null, true, SystemClock.elapsedRealtime() - l, list);
                    }
                    List<zzl> list2 = zzai.zza(list, (zzc)object);
                    return new zzp(304, ((zzc)object).data, true, SystemClock.elapsedRealtime() - l, list2);
                }
                object = zzap2.getContent();
                byArray = object != null ? this.zza((InputStream)object, zzap2.getContentLength()) : new byte[]{};
                int n2 = n;
                byte[] byArray2 = byArray;
                object2 = zzr2;
                long l2 = SystemClock.elapsedRealtime() - l;
                if (DEBUG || l2 > 3000L) {
                    zzae.zzb("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", object2, l2, byArray2 != null ? Integer.valueOf(byArray2.length) : "null", n2, ((zzr)object2).zzi().zzc());
                }
                if (n < 200 || n > 299) {
                    throw new IOException();
                }
                return new zzp(n, byArray, false, SystemClock.elapsedRealtime() - l, list);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzai.zza("socket", zzr2, new zzac());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = String.valueOf(zzr2.getUrl());
                throw new RuntimeException(string2.length() != 0 ? "Bad URL ".concat(string2) : new String("Bad URL "), malformedURLException);
            }
            catch (IOException iOException) {
                if (zzap2 == null) {
                    throw new zzq(iOException);
                }
                n = zzap2.getStatusCode();
                zzae.zzc("Unexpected response code %d for %s", n, zzr2.getUrl());
                if (byArray != null) {
                    object = new zzp(n, byArray, false, SystemClock.elapsedRealtime() - l, list);
                    if (n == 401 || n == 403) {
                        zzai.zza("auth", zzr2, new zza((zzp)object));
                        continue;
                    }
                    if (n >= 400 && n <= 499) {
                        throw new zzg((zzp)object);
                    }
                    if (n >= 500 && n <= 599) {
                        throw new zzab((zzp)object);
                    }
                    throw new zzab((zzp)object);
                }
                zzai.zza("network", zzr2, new zzo());
                continue;
            }
            break;
        }
    }

    private static void zza(String string2, zzr<?> zzr2, zzad zzad2) throws zzad {
        zzaa zzaa2 = zzr2.zzi();
        int n = zzr2.zzh();
        try {
            zzaa2.zza(zzad2);
        }
        catch (zzad zzad3) {
            zzr2.zzb(String.format("%s-timeout-giveup [timeout=%s]", string2, n));
            throw zzad3;
        }
        zzr2.zzb(String.format("%s-retry [timeout=%s]", string2, n));
    }

    private final byte[] zza(InputStream inputStream, int n) throws IOException, zzab {
        byte[] byArray;
        zzat zzat2 = new zzat(this.zzbr, n);
        byte[] byArray2 = null;
        try {
            int n2;
            if (inputStream == null) {
                throw new zzab();
            }
            byArray2 = this.zzbr.zzb(1024);
            while ((n2 = inputStream.read(byArray2)) != -1) {
                zzat2.write(byArray2, 0, n2);
            }
            byArray = zzat2.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                zzae.zza("Error occurred when closing InputStream", new Object[0]);
            }
            this.zzbr.zza(byArray2);
            zzat2.close();
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            zzae.zza("Error occurred when closing InputStream", new Object[0]);
        }
        this.zzbr.zza(byArray2);
        zzat2.close();
        return byArray;
    }

    private static List<zzl> zza(List<zzl> list, zzc zzc2) {
        ArrayList<zzl> arrayList;
        block6: {
            TreeSet<String> treeSet;
            block5: {
                treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (!list.isEmpty()) {
                    for (zzl iterator : list) {
                        treeSet.add(iterator.getName());
                    }
                }
                arrayList = new ArrayList<zzl>(list);
                if (zzc2.zzg == null) break block5;
                if (zzc2.zzg.isEmpty()) break block6;
                for (zzl zzl2 : zzc2.zzg) {
                    if (treeSet.contains(zzl2.getName())) continue;
                    arrayList.add(zzl2);
                }
                break block6;
            }
            if (!zzc2.zzf.isEmpty()) {
                for (Map.Entry<String, String> entry : zzc2.zzf.entrySet()) {
                    if (treeSet.contains(entry.getKey())) continue;
                    arrayList.add(new zzl(entry.getKey(), entry.getValue()));
                }
            }
        }
        return arrayList;
    }
}

