/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzaj;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import java.util.HashMap;

final class zzai
extends zzag
implements Handler.Callback {
    private final HashMap<zzah, zzaj> zzgam = new HashMap();
    private final Context mApplicationContext;
    private final Handler mHandler;
    private final zza zzgan;
    private final long zzgao;
    private final long zzgap;

    zzai(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzgan = zza.zzamc();
        this.zzgao = 5000L;
        this.zzgap = 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zza(zzah zzah2, ServiceConnection serviceConnection, String string2) {
        zzbq.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<zzah, zzaj> hashMap = this.zzgam;
        synchronized (hashMap) {
            zzaj zzaj2 = this.zzgam.get(zzah2);
            if (zzaj2 == null) {
                zzaj2 = new zzaj(this, zzah2);
                zzaj2.zza(serviceConnection, string2);
                zzaj2.zzgi(string2);
                this.zzgam.put(zzah2, zzaj2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzah2);
                if (zzaj2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zzah2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzaj2.zza(serviceConnection, string2);
                switch (zzaj2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzaj2.getComponentName(), zzaj2.getBinder());
                        break;
                    }
                    case 2: {
                        zzaj2.zzgi(string2);
                    }
                }
            }
            return zzaj2.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void zzb(zzah zzah2, ServiceConnection serviceConnection, String string2) {
        zzbq.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<zzah, zzaj> hashMap = this.zzgam;
        synchronized (hashMap) {
            zzaj zzaj2 = this.zzgam.get(zzah2);
            if (zzaj2 == null) {
                String string3 = String.valueOf(zzah2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzaj2.zza(serviceConnection)) {
                String string4 = String.valueOf(zzah2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzaj2.zzb(serviceConnection, string2);
            if (zzaj2.zzalm()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzah2);
                this.mHandler.sendMessageDelayed(message, this.zzgao);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                HashMap<zzah, zzaj> hashMap = this.zzgam;
                synchronized (hashMap) {
                    zzah zzah2 = (zzah)message.obj;
                    zzaj zzaj2 = this.zzgam.get(zzah2);
                    if (zzaj2 != null && zzaj2.zzalm()) {
                        if (zzaj2.isBound()) {
                            zzaj2.zzgj("GmsClientSupervisor");
                        }
                        this.zzgam.remove(zzah2);
                    }
                }
                return true;
            }
            case 1: {
                HashMap<zzah, zzaj> hashMap = this.zzgam;
                synchronized (hashMap) {
                    zzah zzah3 = (zzah)message.obj;
                    zzaj zzaj3 = this.zzgam.get(zzah3);
                    if (zzaj3 != null && zzaj3.getState() == 3) {
                        String string2 = String.valueOf(zzah3);
                        Log.wtf((String)"GmsClientSupervisor", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Timeout waiting for ServiceConnection callback ").append(string2).toString(), (Throwable)new Exception());
                        string2 = zzaj3.getComponentName();
                        if (string2 == null) {
                            string2 = zzah3.getComponentName();
                        }
                        if (string2 == null) {
                            string2 = new ComponentName(zzah3.getPackage(), "unknown");
                        }
                        zzaj3.onServiceDisconnected((ComponentName)string2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ HashMap zza(zzai zzai2) {
        return zzai2.zzgam;
    }

    static /* synthetic */ Handler zzb(zzai zzai2) {
        return zzai2.mHandler;
    }

    static /* synthetic */ Context zzc(zzai zzai2) {
        return zzai2.mApplicationContext;
    }

    static /* synthetic */ zza zzd(zzai zzai2) {
        return zzai2.zzgan;
    }

    static /* synthetic */ long zze(zzai zzai2) {
        return zzai2.zzgap;
    }
}

