/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzfo;
import com.google.android.gms.internal.zzfp;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzamu;
    @Nullable
    private zzfo zzamv;
    private boolean zzamw;
    private Object zzamx = new Object();
    @Nullable
    private zza zzamy;
    private final Context mContext;
    private boolean zzamz;
    private long zzana;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl, boolean bl2) {
        Context context2;
        zzbq.checkNotNull(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzamw = false;
        this.zzana = l;
        this.zzamz = bl2;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbq.zzgn("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzamw) {
                this.finish();
            }
            this.zzamu = AdvertisingIdClient.zzc(this.mContext, this.zzamz);
            this.zzamv = AdvertisingIdClient.zza(this.mContext, this.zzamu);
            this.zzamw = true;
            if (bl) {
                this.zzbo();
            }
            return;
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbo() {
        Object object = this.zzamx;
        synchronized (object) {
            if (this.zzamy != null) {
                this.zzamy.zzane.countDown();
                try {
                    this.zzamy.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzana > 0L) {
                this.zzamy = new zza(this, this.zzana);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzbq.zzgn("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzamw) {
                Object object = this.zzamx;
                synchronized (object) {
                    if (this.zzamy == null || !this.zzamy.zzanf) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzamw) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbq.checkNotNull(this.zzamu);
            zzbq.checkNotNull(this.zzamv);
            try {
                info = new Info(this.zzamv.getId(), this.zzamv.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbo();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsAdIdFakeForDebugLogging() throws IOException {
        boolean bl;
        zzbq.zzgn("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzamw) {
                Object object = this.zzamx;
                synchronized (object) {
                    if (this.zzamy == null || !this.zzamy.zzanf) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzamw) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbq.checkNotNull(this.zzamu);
            zzbq.checkNotNull(this.zzamv);
            try {
                bl = this.zzamv.zzbp();
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbo();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzbq.zzgn("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzamu == null) {
                return;
            }
            try {
                if (this.zzamw) {
                    com.google.android.gms.common.stats.zza.zzamc();
                    com.google.android.gms.common.zza zza2 = this.zzamu;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzamw = false;
            this.zzamv = null;
            this.zzamu = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzc(Context context, boolean bl) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zzf.zzafy().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        String string2 = bl ? "com.google.android.gms.ads.identifier.service.PERSISTENT_START" : "com.google.android.gms.ads.identifier.service.START";
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent(string2);
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzamc().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl = zzb2.getBoolean("gads:ad_id_app_context:enabled", false);
        float f = zzb2.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
        String string2 = zzb2.getString("gads:ad_id_use_shared_preference:experiment_id", "");
        boolean bl2 = zzb2.getBoolean("gads:ad_id_use_persistent_service:enabled", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl, bl2);
        try {
            long l = SystemClock.elapsedRealtime();
            advertisingIdClient.start(false);
            Info info = advertisingIdClient.getInfo();
            long l2 = SystemClock.elapsedRealtime();
            advertisingIdClient.zza(info, bl, f, l2 - l, string2, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            advertisingIdClient.zza(null, bl, f, -1L, string2, throwable);
            throw throwable;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    public static boolean getIsAdIdFakeForDebugLogging(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl = zzb2.getBoolean("gads:ad_id_app_context:enabled", false);
        boolean bl2 = zzb2.getBoolean("com.google.android.gms.ads.identifier.service.PERSISTENT_START", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl, bl2);
        try {
            advertisingIdClient.start(false);
            boolean bl3 = advertisingIdClient.getIsAdIdFakeForDebugLogging();
            return bl3;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    private final boolean zza(Info info, boolean bl, float f, long l, String string2, Throwable throwable) {
        if (Math.random() > (double)f) {
            return false;
        }
        Throwable throwable2 = throwable;
        String string3 = string2;
        long l2 = l;
        boolean bl2 = bl;
        Info info2 = info;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            hashMap.put("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            hashMap.put("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            hashMap.put("error", throwable2.getClass().getName());
        }
        if (string3 != null && !string3.isEmpty()) {
            hashMap.put("experiment_id", string3);
        }
        hashMap.put("tag", "AdvertisingIdClient");
        hashMap.put("time_spent", Long.toString(l2));
        HashMap<String, String> hashMap2 = hashMap;
        new com.google.android.gms.ads.identifier.zza(this, hashMap2).start();
        return true;
    }

    private static zzfo zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzfp.zzc(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzang;
        private final boolean zzanh;

        public Info(String string2, boolean bl) {
            this.zzang = string2;
            this.zzanh = bl;
        }

        public final String getId() {
            return this.zzang;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzanh;
        }

        public final String toString() {
            String string2 = this.zzang;
            boolean bl = this.zzanh;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzanc;
        private long zzand;
        CountDownLatch zzane;
        boolean zzanf;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzanc = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzand = l;
            this.zzane = new CountDownLatch(1);
            this.zzanf = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzanc.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzanf = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzane.await(this.zzand, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

