/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.WorkSource;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.util.zzu;
import com.google.android.gms.internal.zzbgc;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class zzy {
    private static final Method zzgcc = zzy.zzamd();
    private static final Method zzgcd = zzy.zzame();
    private static final Method zzgce = zzy.zzamf();
    private static final Method zzgcf = zzy.zzamg();
    private static final Method zzgcg = zzy.zzamh();

    private static WorkSource zze(int n, String string2) {
        WorkSource workSource = new WorkSource();
        String string3 = string2;
        int n2 = n;
        WorkSource workSource2 = workSource;
        if (zzgcd != null) {
            if (string3 == null) {
                string3 = "";
            }
            try {
                zzgcd.invoke((Object)workSource2, n2, string3);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        } else if (zzgcc != null) {
            try {
                zzgcc.invoke((Object)workSource2, n2);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return workSource;
    }

    @Nullable
    public static WorkSource zzaa(Context context, @Nullable String string2) {
        ApplicationInfo applicationInfo;
        if (context == null || context.getPackageManager() == null || string2 == null) {
            return null;
        }
        try {
            applicationInfo = zzbgc.zzcy(context).getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string3.length() != 0 ? "Could not find package: ".concat(string3) : new String("Could not find package: ")));
            return null;
        }
        if (applicationInfo == null) {
            String string4 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string4.length() != 0 ? "Could not get applicationInfo from package: ".concat(string4) : new String("Could not get applicationInfo from package: ")));
            return null;
        }
        return zzy.zze(applicationInfo.uid, string2);
    }

    private static int zza(WorkSource workSource) {
        if (zzgce != null) {
            try {
                return (Integer)zzgce.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    @Nullable
    private static String zza(WorkSource workSource, int n) {
        if (zzgcg != null) {
            try {
                return (String)zzgcg.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> zzb(@Nullable WorkSource workSource) {
        int n = workSource == null ? 0 : zzy.zza(workSource);
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string2 = zzy.zza(workSource, i);
            if (zzu.zzgn(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean zzcv(Context context) {
        if (context == null) {
            return false;
        }
        if (context.getPackageManager() == null) {
            return false;
        }
        return zzbgc.zzcy(context).checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName()) == 0;
    }

    private static Method zzamd() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzame() {
        Method method = null;
        if (zzq.zzaly()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {}
        }
        return method;
    }

    private static Method zzamf() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzamg() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzamh() {
        Method method = null;
        if (zzq.zzaly()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {}
        }
        return method;
    }
}

