/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.util.zzw;

public final class zzbq {
    @NonNull
    public static <T> T checkNotNull(@Nullable T t) {
        if (t == null) {
            throw new NullPointerException("null reference");
        }
        return t;
    }

    public static String zzgh(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Given String is empty or null");
        }
        return string2;
    }

    public static String zzh(String string2, Object object) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return string2;
    }

    public static <T> T checkNotNull(T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static int zza(int n, Object object) {
        if (n == 0) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return n;
    }

    public static long zza(long l, Object object) {
        if (l == 0L) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return l;
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void zza(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void zza(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(String.format(string2, objectArray));
        }
    }

    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void zzb(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string2, objectArray));
        }
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void zzfz(String string2) {
        if (!zzw.zzas()) {
            throw new IllegalStateException(string2);
        }
    }

    public static void zzgi(String string2) {
        if (zzw.zzas()) {
            throw new IllegalStateException(string2);
        }
    }

    public static void zza(Handler handler) {
        if (Looper.myLooper() != handler.getLooper()) {
            throw new IllegalStateException("Must be called on the handler thread");
        }
    }
}

