/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfdl;
import com.google.android.gms.internal.zzfez;
import com.google.android.gms.internal.zzffc;
import com.google.android.gms.internal.zzffd;
import com.google.android.gms.internal.zzffv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfey
extends zzfdl<Integer>
implements zzffc,
zzffv,
RandomAccess {
    private static final zzfey zzpde = new zzfey();
    private int[] zzpdf;
    private int size;

    public static zzfey zzcvr() {
        return zzpde;
    }

    zzfey() {
        this(new int[10], 0);
    }

    private zzfey(int[] nArray, int n) {
        this.zzpdf = nArray;
        this.size = n;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfey)) {
            return super.equals(object);
        }
        zzfey zzfey2 = (zzfey)object;
        if (this.size != zzfey2.size) {
            return false;
        }
        int[] nArray = zzfey2.zzpdf;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzpdf[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzpdf[i];
        }
        return n;
    }

    @Override
    public final zzffc zzlk(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzfey(Arrays.copyOf(this.zzpdf, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzlm(n);
        return this.zzpdf[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzll(int n) {
        this.zzai(this.size, n);
    }

    private final void zzai(int n, int n2) {
        this.zzctj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzln(n));
        }
        if (this.size < this.zzpdf.length) {
            System.arraycopy(this.zzpdf, n, this.zzpdf, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzpdf, 0, nArray, 0, n);
            System.arraycopy(this.zzpdf, n, nArray, n + 1, this.size - n);
            this.zzpdf = nArray;
        }
        this.zzpdf[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzctj();
        zzfez.checkNotNull(collection);
        if (!(collection instanceof zzfey)) {
            return super.addAll(collection);
        }
        zzfey zzfey2 = (zzfey)collection;
        if (zzfey2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfey2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfey2.size;
        if (n > this.zzpdf.length) {
            this.zzpdf = Arrays.copyOf(this.zzpdf, n);
        }
        System.arraycopy(zzfey2.zzpdf, 0, this.zzpdf, this.size, zzfey2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzctj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzpdf[i])) continue;
            System.arraycopy(this.zzpdf, i + 1, this.zzpdf, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzlm(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzln(n));
        }
    }

    private final String zzln(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfey zzfey2 = this;
        zzfey2.zzctj();
        zzfey2.zzlm(n);
        int n4 = zzfey2.zzpdf[n];
        zzfey2.zzpdf[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfey zzfey2 = this;
        zzfey2.zzctj();
        zzfey2.zzlm(n);
        int n2 = zzfey2.zzpdf[n];
        System.arraycopy(zzfey2.zzpdf, n + 1, zzfey2.zzpdf, n, zzfey2.size - n);
        --zzfey2.size;
        ++zzfey2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzai(n, n2);
    }

    @Override
    public final /* synthetic */ zzffd zzlo(int n) {
        return this.zzlk(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzpde.zzbin();
    }
}

