/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzan;
import com.google.android.gms.common.internal.zzay;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzfvt;
    private long zzfvu;
    private long zzfvv;
    private int zzfvw;
    private long zzfvx;
    private zzam zzfvy;
    private final Context mContext;
    private final Looper zzakm;
    private final zzag zzfvz;
    private final zze zzfns;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzfwa = new Object();
    private zzay zzfwb;
    protected zzj zzfwc;
    private T zzfwd;
    private final ArrayList<zzi<?>> zzfwe = new ArrayList();
    private zzl zzfwf;
    private int zzfwg = 1;
    private final zzf zzfwh;
    private final zzg zzfwi;
    private final int zzfwj;
    private final String zzfwk;
    private ConnectionResult zzfwl = null;
    private boolean zzfwm = false;
    protected AtomicInteger zzfwn = new AtomicInteger(0);
    private static String[] zzfwo = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzag.zzcl(context), zze.zzafn(), n, zzbq.checkNotNull(zzf2), zzbq.checkNotNull(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzag zzag2, zze zze2, int n, zzf zzf2, zzg zzg2, String string2) {
        this.mContext = zzbq.checkNotNull(context, "Context must not be null");
        this.zzakm = zzbq.checkNotNull(looper, "Looper must not be null");
        this.zzfvz = zzbq.checkNotNull(zzag2, "Supervisor must not be null");
        this.zzfns = zzbq.checkNotNull(zze2, "API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzfwj = n;
        this.zzfwh = zzf2;
        this.zzfwi = zzg2;
        this.zzfwk = string2;
    }

    @NonNull
    protected abstract String zzhf();

    protected String zzajw() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzhg();

    @Nullable
    private final String zzajx() {
        if (this.zzfwk == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzfwk;
    }

    @Nullable
    protected abstract T zzd(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzfvv = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzfvt = n;
        this.zzfvu = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzfvw = connectionResult.getErrorCode();
        this.zzfvx = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbq.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzfwg = n;
            this.zzfwd = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzfwf != null && zzd2.zzfvy != null) {
                        String string3 = zzd2.zzfvy.zzald();
                        string2 = zzd2.zzfvy.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzfvz.zza(zzd2.zzfvy.zzald(), zzd2.zzfvy.getPackageName(), zzd2.zzfvy.zzakz(), zzd2.zzfwf, zzd2.zzajx());
                        zzd2.zzfwn.incrementAndGet();
                    }
                    zzd2.zzfwf = new zzl(zzd2, zzd2.zzfwn.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzfvy = new zzam(zzd3.zzajw(), zzd3.zzhf(), false, 129);
                    String string4 = zzd2.zzajx();
                    zzl zzl2 = zzd2.zzfwf;
                    int n2 = zzd2.zzfvy.zzakz();
                    String string5 = zzd2.zzfvy.getPackageName();
                    String string6 = zzd2.zzfvy.zzald();
                    if (zzd2.zzfvz.zza(new zzah(string6, string5, n2), (ServiceConnection)zzl2, string4)) break;
                    string2 = zzd2.zzfvy.zzald();
                    String string7 = zzd2.zzfvy.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzfwn.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzfwf == null) break;
                    zzd4.zzfvz.zza(zzd4.zzhf(), zzd4.zzajw(), 129, zzd4.zzfwf, zzd4.zzajx());
                    zzd4.zzfwf = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfwg != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzajy() {
        int n = this.zzfns.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzfwc = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfwg == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfwg == 2 || this.zzfwg == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzajz() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfwg == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzfwn.incrementAndGet();
        Object object = this.zzfwe;
        synchronized (object) {
            int n = this.zzfwe.size();
            for (int i = 0; i < n; ++i) {
                this.zzfwe.get(i).removeListener();
            }
            this.zzfwe.clear();
        }
        object = this.zzfwa;
        synchronized (object) {
            this.zzfwb = null;
        }
        this.zza(1, null);
    }

    public final void zzcf(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzfwn.get(), n));
    }

    private final void zzcg(int n) {
        int n2;
        if (this.zzajz()) {
            n2 = 5;
            this.zzfwm = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzfwn.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzfwc = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzfwn.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzakm;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzaka() {
        return new zzc[0];
    }

    protected Bundle zzaae() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    protected final void zzakb() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzaex() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzakc() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfwg == 5) {
                throw new DeadObjectException();
            }
            this.zzakb();
            zzbq.zza(this.zzfwd != null, (Object)"Client is connected but service is null");
            return this.zzfwd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(zzan zzan2, Set<Scope> set) {
        Bundle bundle = this.zzaae();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzz(this.zzfwj);
        new zzz(this.zzfwj).zzfxj = object;
        object = bundle;
        v0.zzfxm = object;
        zzz zzz2 = object2;
        if (set != null) {
            object = set;
            zzz2.zzfxl = object.toArray(new Scope[object.size()]);
        }
        if (this.zzaan()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzz2;
            zzz2.zzfxn = object;
            object = zzan2;
            if (object != null) {
                ((zzz)object2).zzfxk = object.asBinder();
            }
        } else if (this.zzakd()) {
            zzz2.zzfxn = object = this.getAccount();
        }
        object = this.zzaka();
        zzz2.zzfxo = object;
        try {
            Object object3 = this.zzfwa;
            synchronized (object3) {
                if (this.zzfwb != null) {
                    this.zzfwb.zza(new zzk(this, this.zzfwn.get()), zzz2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzcf(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzfwn.get());
            return;
        }
    }

    public boolean zzaan() {
        return false;
    }

    public void zza(@NonNull zzp zzp2) {
        zzp2.zzaiu();
    }

    public boolean zzakd() {
        return false;
    }

    public boolean zzafv() {
        return true;
    }

    public boolean zzaax() {
        return false;
    }

    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzake() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzay zzay2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzfwg;
            t = this.zzfwd;
        }
        object = this.zzfwa;
        synchronized (object) {
            zzay2 = this.zzfwb;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzhg()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzay2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzay2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzfvv > 0L) {
            l = this.zzfvv;
            string3 = ((DateFormat)object).format(new Date(this.zzfvv));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfvu > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzfvt) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzfvt));
                }
            }
            l = this.zzfvu;
            string3 = ((DateFormat)object).format(new Date(this.zzfvu));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfvx > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzfvw));
            l = this.zzfvx;
            string3 = ((DateFormat)object).format(new Date(this.zzfvx));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IBinder zzafw() {
        Object object = this.zzfwa;
        synchronized (object) {
            if (this.zzfwb == null) {
                return null;
            }
            return this.zzfwb.asBinder();
        }
    }

    private final boolean zzakf() {
        if (this.zzfwm) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzhg())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzhg());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzcg(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzfwa;
    }

    static /* synthetic */ zzay zza(zzd zzd2, zzay zzay2) {
        zzd2.zzfwb = zzay2;
        return zzd2.zzfwb;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzfwl = connectionResult;
        return zzd2.zzfwl;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzakf();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzfwm;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzfwl;
    }

    static /* synthetic */ zzf zze(zzd zzd2) {
        return zzd2.zzfwh;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzfwe;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzfwi;
    }
}

