/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzax;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzfso;
    private long zzfsp;
    private long zzfsq;
    private int zzfsr;
    private long zzfss;
    private zzal zzfst;
    private final Context mContext;
    private final Looper zzakg;
    private final zzaf zzfsu;
    private final zze zzfko;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzfsv = new Object();
    private zzax zzfsw;
    protected zzj zzfsx;
    private T zzfsy;
    private final ArrayList<zzi<?>> zzfsz = new ArrayList();
    private zzl zzfta;
    private int zzftb = 1;
    private final zzf zzftc;
    private final zzg zzftd;
    private final int zzfte;
    private final String zzftf;
    private ConnectionResult zzftg = null;
    private boolean zzfth = false;
    protected AtomicInteger zzfti = new AtomicInteger(0);
    private static String[] zzftj = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzaf.zzce(context), zze.zzaex(), n, zzbp.zzu(zzf2), zzbp.zzu(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzaf zzaf2, zze zze2, int n, zzf zzf2, zzg zzg2, String string2) {
        this.mContext = zzbp.zzb(context, (Object)"Context must not be null");
        this.zzakg = zzbp.zzb(looper, (Object)"Looper must not be null");
        this.zzfsu = zzbp.zzb(zzaf2, (Object)"Supervisor must not be null");
        this.zzfko = zzbp.zzb(zze2, (Object)"API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzfte = n;
        this.zzftc = zzf2;
        this.zzftd = zzg2;
        this.zzftf = string2;
    }

    @NonNull
    protected abstract String zzhc();

    protected String zzajd() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzhd();

    @Nullable
    private final String zzaje() {
        if (this.zzftf == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzftf;
    }

    @Nullable
    protected abstract T zzd(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzfsq = System.currentTimeMillis();
    }

    @CallSuper
    protected final void onConnectionSuspended(int n) {
        this.zzfso = n;
        this.zzfsp = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzfsr = connectionResult.getErrorCode();
        this.zzfss = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbp.zzbh(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzftb = n;
            this.zzfsy = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzfta != null && zzd2.zzfst != null) {
                        String string3 = zzd2.zzfst.zzakk();
                        string2 = zzd2.zzfst.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzfsu.zza(zzd2.zzfst.zzakk(), zzd2.zzfst.getPackageName(), zzd2.zzfst.zzakg(), zzd2.zzfta, zzd2.zzaje());
                        zzd2.zzfti.incrementAndGet();
                    }
                    zzd2.zzfta = new zzl(zzd2, zzd2.zzfti.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzfst = new zzal(zzd3.zzajd(), zzd3.zzhc(), false, 129);
                    String string4 = zzd2.zzaje();
                    zzl zzl2 = zzd2.zzfta;
                    int n2 = zzd2.zzfst.zzakg();
                    String string5 = zzd2.zzfst.getPackageName();
                    String string6 = zzd2.zzfst.zzakk();
                    if (zzd2.zzfsu.zza(new zzag(string6, string5, n2), (ServiceConnection)zzl2, string4)) break;
                    string2 = zzd2.zzfst.zzakk();
                    String string7 = zzd2.zzfst.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzfti.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzfta == null) break;
                    zzd4.zzfsu.zza(zzd4.zzhc(), zzd4.zzajd(), 129, zzd4.zzfta, zzd4.zzaje());
                    zzd4.zzfta = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzftb != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzajf() {
        int n = this.zzfko.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzfsx = zzbp.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzftb == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzftb == 2 || this.zzftb == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzajg() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzftb == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzfti.incrementAndGet();
        Object object = this.zzfsz;
        synchronized (object) {
            int n = this.zzfsz.size();
            for (int i = 0; i < n; ++i) {
                this.zzfsz.get(i).removeListener();
            }
            this.zzfsz.clear();
        }
        object = this.zzfsv;
        synchronized (object) {
            this.zzfsw = null;
        }
        this.zza(1, null);
    }

    public final void zzcc(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzfti.get(), n));
    }

    private final void zzcd(int n) {
        int n2;
        if (this.zzajg()) {
            n2 = 5;
            this.zzfth = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzfti.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzfsx = zzbp.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzfti.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzakg;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzajh() {
        return new zzc[0];
    }

    protected Bundle zzzu() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    protected final void zzaji() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzaeh() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzajj() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzftb == 5) {
                throw new DeadObjectException();
            }
            this.zzaji();
            zzbp.zza(this.zzfsy != null, (Object)"Client is connected but service is null");
            return this.zzfsy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(zzam zzam2, Set<Scope> set) {
        Bundle bundle = this.zzzu();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzy(this.zzfte);
        new zzy(this.zzfte).zzfue = object;
        object = bundle;
        v0.zzfuh = object;
        zzy zzy2 = object2;
        if (set != null) {
            object = set;
            zzy2.zzfug = object.toArray(new Scope[object.size()]);
        }
        if (this.zzaac()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzy2;
            zzy2.zzfui = object;
            object = zzam2;
            if (object != null) {
                ((zzy)object2).zzfuf = object.asBinder();
            }
        } else if (this.zzajk()) {
            zzy2.zzfui = object = this.getAccount();
        }
        object = this.zzajh();
        zzy2.zzfuj = object;
        try {
            Object object3 = this.zzfsv;
            synchronized (object3) {
                if (this.zzfsw != null) {
                    this.zzfsw.zza(new zzk(this, this.zzfti.get()), zzy2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzcc(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzfti.get());
            return;
        }
    }

    public boolean zzaac() {
        return false;
    }

    public boolean zzajk() {
        return false;
    }

    public boolean zzaff() {
        return true;
    }

    public boolean zzaal() {
        return false;
    }

    public Intent zzaam() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzajl() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzax zzax2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzftb;
            t = this.zzfsy;
        }
        object = this.zzfsv;
        synchronized (object) {
            zzax2 = this.zzfsw;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzhd()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzax2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzax2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzfsq > 0L) {
            l = this.zzfsq;
            string3 = ((DateFormat)object).format(new Date(this.zzfsq));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfsp > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzfso) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzfso));
                }
            }
            l = this.zzfsp;
            string3 = ((DateFormat)object).format(new Date(this.zzfsp));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfss > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzfsr));
            l = this.zzfss;
            string3 = ((DateFormat)object).format(new Date(this.zzfss));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IBinder zzafg() {
        Object object = this.zzfsv;
        synchronized (object) {
            if (this.zzfsw == null) {
                return null;
            }
            return this.zzfsw.asBinder();
        }
    }

    private final boolean zzajm() {
        if (this.zzfth) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzhd())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzhd());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzcd(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzfsv;
    }

    static /* synthetic */ zzax zza(zzd zzd2, zzax zzax2) {
        zzd2.zzfsw = zzax2;
        return zzd2.zzfsw;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzftg = connectionResult;
        return zzd2.zzftg;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzajm();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzfth;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzftg;
    }

    static /* synthetic */ zzf zze(zzd zzd2) {
        return zzd2.zzftc;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzfsz;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzftd;
    }
}

