/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.ads.identifier.zzd;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzew;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzall;
    @Nullable
    private zzev zzalm;
    private boolean zzaln;
    private Object zzalo = new Object();
    @Nullable
    private zza zzalp;
    private final Context mContext;
    private long zzalq;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzbp.zzu(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzaln = false;
        this.zzalq = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbp.zzgh("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzaln) {
                this.finish();
            }
            this.zzall = AdvertisingIdClient.zzc(this.mContext);
            this.zzalm = AdvertisingIdClient.zza(this.mContext, this.zzall);
            this.zzaln = true;
            if (bl) {
                this.zzbh();
            }
            return;
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbh() {
        Object object = this.zzalo;
        synchronized (object) {
            if (this.zzalp != null) {
                this.zzalp.zzalu.countDown();
                try {
                    this.zzalp.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzalq > 0L) {
                this.zzalp = new zza(this, this.zzalq);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzbp.zzgh("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzaln) {
                Object object = this.zzalo;
                synchronized (object) {
                    if (this.zzalp == null || !this.zzalp.zzalv) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzaln) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbp.zzu(this.zzall);
            zzbp.zzu(this.zzalm);
            try {
                info = new Info(this.zzalm.getId(), this.zzalm.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbh();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzbp.zzgh("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzall == null) {
                return;
            }
            try {
                if (this.zzaln) {
                    com.google.android.gms.common.stats.zza.zzaky();
                    com.google.android.gms.common.zza zza2 = this.zzall;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzaln = false;
            this.zzalm = null;
            this.zzall = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzc(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zze.zzaex().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzaky().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        zzd zzd2 = new zzd(context);
        boolean bl = zzd2.getBoolean("gads:ad_id_app_context:enabled", false);
        float f = zzd2.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
        boolean bl2 = zzd2.getBoolean("gads:ad_id_use_shared_preference:enabled", false);
        String string2 = zzd2.getString("gads:ad_id_use_shared_preference:experiment_id", "");
        if (bl2 && (object = zzb.zzd(context).getInfo()) != null) {
            return object;
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            long l = SystemClock.elapsedRealtime();
            super.start(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            long l2 = SystemClock.elapsedRealtime();
            super.zza(info, bl, f, l2 - l, string2, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, -1L, string2, throwable);
            throw throwable;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private final boolean zza(Info info, boolean bl, float f, long l, String string2, Throwable throwable) {
        if (Math.random() > (double)f) {
            return false;
        }
        Throwable throwable2 = throwable;
        String string3 = string2;
        long l2 = l;
        boolean bl2 = bl;
        Info info2 = info;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            hashMap.put("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            hashMap.put("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            hashMap.put("error", throwable2.getClass().getName());
        }
        if (string3 != null && !string3.isEmpty()) {
            hashMap.put("experiment_id", string3);
        }
        hashMap.put("tag", "AdvertisingIdClient");
        hashMap.put("time_spent", Long.toString(l2));
        HashMap<String, String> hashMap2 = hashMap;
        new com.google.android.gms.ads.identifier.zza(this, hashMap2).start();
        return true;
    }

    private static zzev zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzew.zzc(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzalw;
        private final boolean zzalx;

        public Info(String string2, boolean bl) {
            this.zzalw = string2;
            this.zzalx = bl;
        }

        public final String getId() {
            return this.zzalw;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzalx;
        }

        public final String toString() {
            String string2 = this.zzalw;
            boolean bl = this.zzalx;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzals;
        private long zzalt;
        CountDownLatch zzalu;
        boolean zzalv;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzals = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzalt = l;
            this.zzalu = new CountDownLatch(1);
            this.zzalv = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzals.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzalv = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzalu.await(this.zzalt, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

