/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.ads.identifier.zzd;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzew;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzalk;
    @Nullable
    private zzev zzall;
    private boolean zzalm;
    private Object zzaln = new Object();
    @Nullable
    private zza zzalo;
    private final Context mContext;
    private long zzalp;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzbp.zzu(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzalm = false;
        this.zzalp = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbp.zzgh("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzalm) {
                this.finish();
            }
            this.zzalk = AdvertisingIdClient.zzc(this.mContext);
            this.zzall = AdvertisingIdClient.zza(this.mContext, this.zzalk);
            this.zzalm = true;
            if (bl) {
                this.zzbh();
            }
            return;
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbh() {
        Object object = this.zzaln;
        synchronized (object) {
            if (this.zzalo != null) {
                this.zzalo.zzalt.countDown();
                try {
                    this.zzalo.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzalp > 0L) {
                this.zzalo = new zza(this, this.zzalp);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzbp.zzgh("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzalm) {
                Object object = this.zzaln;
                synchronized (object) {
                    if (this.zzalo == null || !this.zzalo.zzalu) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzalm) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbp.zzu(this.zzalk);
            zzbp.zzu(this.zzall);
            try {
                info = new Info(this.zzall.getId(), this.zzall.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbh();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzbp.zzgh("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzalk == null) {
                return;
            }
            try {
                if (this.zzalm) {
                    com.google.android.gms.common.stats.zza.zzakz();
                    com.google.android.gms.common.zza zza2 = this.zzalk;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzalm = false;
            this.zzall = null;
            this.zzalk = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzc(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zze.zzaex().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzakz().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        zzd zzd2 = new zzd(context);
        boolean bl = zzd2.getBoolean("gads:ad_id_app_context:enabled", false);
        float f = zzd2.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
        boolean bl2 = zzd2.getBoolean("gads:ad_id_use_shared_preference:enabled", false);
        String string2 = zzd2.getString("gads:ad_id_use_shared_preference:experiment_id", "");
        if (bl2 && (object = zzb.zzd(context).getInfo()) != null) {
            return object;
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            long l = SystemClock.elapsedRealtime();
            super.start(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            long l2 = SystemClock.elapsedRealtime();
            super.zza(info, bl, f, l2 - l, string2, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, -1L, string2, throwable);
            throw throwable;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private final boolean zza(Info info, boolean bl, float f, long l, String string2, Throwable throwable) {
        if (Math.random() > (double)f) {
            return false;
        }
        Throwable throwable2 = throwable;
        String string3 = string2;
        long l2 = l;
        boolean bl2 = bl;
        Info info2 = info;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            hashMap.put("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            hashMap.put("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            hashMap.put("error", throwable2.getClass().getName());
        }
        if (string3 != null && !string3.isEmpty()) {
            hashMap.put("experiment_id", string3);
        }
        hashMap.put("tag", "AdvertisingIdClient");
        hashMap.put("time_spent", Long.toString(l2));
        HashMap<String, String> hashMap2 = hashMap;
        new com.google.android.gms.ads.identifier.zza(this, hashMap2).start();
        return true;
    }

    private static zzev zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzew.zzc(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzalv;
        private final boolean zzalw;

        public Info(String string2, boolean bl) {
            this.zzalv = string2;
            this.zzalw = bl;
        }

        public final String getId() {
            return this.zzalv;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzalw;
        }

        public final String toString() {
            String string2 = this.zzalv;
            boolean bl = this.zzalw;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzalr;
        private long zzals;
        CountDownLatch zzalt;
        boolean zzalu;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzalr = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzals = l;
            this.zzalt = new CountDownLatch(1);
            this.zzalu = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzalr.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzalu = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzalt.await(this.zzals, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

